/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.dom;

import com.newrelic.agent.extension.beans.Pointcut;
import java.text.MessageFormat;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PointcutAttrs {
    IGNORE_TRANS("ignoreTransaction", false){

        void addAtt(Pointcut pPc, Node pNode) {
            String value = PointcutAttrs.getAttribute(pNode, this.getAttName(), this.isRequired());
            if (value != null) {
                pPc.setIgnoreTransaction(Boolean.valueOf(value.trim()));
            }
        }
    }
    ,
    EXCLUDE_FROM_TRANS_TRANCE("excludeFromTransactionTrace", false){

        void addAtt(Pointcut pPc, Node pNode) {
            String value = PointcutAttrs.getAttribute(pNode, this.getAttName(), this.isRequired());
            if (value != null) {
                pPc.setExcludeFromTransactionTrace(Boolean.valueOf(value.trim()));
            }
        }
    }
    ,
    METRIC_NAME_FORMAT("metricNameFormat", false){

        void addAtt(Pointcut pPc, Node pNode) {
            String value = PointcutAttrs.getAttribute(pNode, this.getAttName(), this.isRequired());
            if (value != null) {
                pPc.setMetricNameFormat(value.trim());
            }
        }
    }
    ,
    TRANS_START_POINT("transactionStartPoint", false){

        void addAtt(Pointcut pPc, Node pNode) {
            String value = PointcutAttrs.getAttribute(pNode, this.getAttName(), this.isRequired());
            if (value != null) {
                pPc.setTransactionStartPoint(Boolean.valueOf(value.trim()));
            }
        }
    };

    private String attName;
    private boolean required;

    private PointcutAttrs(String pName, boolean pRequired) {
        this.attName = pName;
        this.required = pRequired;
    }

    public String getAttName() {
        return this.attName;
    }

    public boolean isRequired() {
        return this.required;
    }

    abstract void addAtt(Pointcut var1, Node var2);

    private static String getAttribute(Node node, String pAttName, boolean pRequired) {
        if (node.hasAttributes()) {
            NamedNodeMap map = node.getAttributes();
            Node value = map.getNamedItem(pAttName);
            if (value != null) {
                return value.getNodeValue();
            }
            if (pRequired) {
                throw new RuntimeException(MessageFormat.format("{0} is a required attribute for the pointcut.", pAttName));
            }
        } else if (pRequired) {
            throw new RuntimeException(MessageFormat.format("{0} is a required attribute for the pointcut.", pAttName));
        }
        return null;
    }
}

