/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.dom;

import com.newrelic.agent.Agent;
import com.newrelic.agent.extension.beans.Extension;
import com.newrelic.agent.extension.beans.Instrumentation;
import com.newrelic.agent.extension.beans.Method;
import com.newrelic.agent.extension.beans.Pointcut;
import com.newrelic.agent.extension.dom.ExtensionAttrs;
import com.newrelic.agent.extension.dom.InstAttrs;
import com.newrelic.agent.extension.dom.PointcutAttrs;
import com.newrelic.agent.extension.util.MethodParameters;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDomParser {
    private static final String EXTENSION = "extension";
    private static final String INSTRUMENTATION = "instrumentation";
    private static final String POINTCUT = "pointcut";
    private static final String METHOD = "method";
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "name";
    private static final String METHOD_PARAMS = "parameters";
    private static final String PARAM_TYPES = "type";

    public static Extension readFileCatchException(File file) {
        try {
            return ExtensionDomParser.readFile(file);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to read extension {0}. Skipping the extension. Reason: {1}", file.getName(), e.getMessage()));
            Agent.LOG.log(Level.FINER, "Reason For Failure: " + e.getMessage(), e);
            return null;
        }
    }

    public static Extension readFile(File file) throws SAXException, IOException {
        Document doc = ExtensionDomParser.getDocument(file);
        return ExtensionDomParser.getValues(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getDocument(File file) throws SAXException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(fis));
            Document document = parser.getDocument();
            return document;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Extension getValues(Document doc) {
        Extension ext = new Extension();
        Element root = ExtensionDomParser.getExtension(ext, doc);
        Node instrument = ExtensionDomParser.getChildNode(INSTRUMENTATION, root.getChildNodes());
        if (instrument != null) {
            Instrumentation inst = new Instrumentation();
            ext.setInstrumentation(inst);
            ExtensionDomParser.setInstAttr(inst, instrument);
            List<Node> pointcuts = ExtensionDomParser.getChildNodes(POINTCUT, instrument.getChildNodes());
            for (Node current : pointcuts) {
                Pointcut pc = ExtensionDomParser.getPointcut(current);
                if (pc == null) continue;
                inst.addPointCut(pc);
            }
        }
        return ext;
    }

    private static Element getExtension(Extension ext, Document doc) {
        ExtensionAttrs[] extAtts;
        Element root = doc.getDocumentElement();
        if (root == null || !root.getLocalName().equals(EXTENSION)) {
            throw new IllegalArgumentException("The root of the xml must be an extension node.");
        }
        for (ExtensionAttrs current : extAtts = ExtensionAttrs.values()) {
            current.addAtt(ext, root);
        }
        return root;
    }

    private static void setInstAttr(Instrumentation inst, Node instNode) {
        InstAttrs[] attributes;
        for (InstAttrs current : attributes = InstAttrs.values()) {
            current.addAtt(inst, instNode);
        }
    }

    private static Pointcut getPointcut(Node current) {
        PointcutAttrs[] attrs;
        Pointcut pc = new Pointcut();
        for (PointcutAttrs currentAttr : attrs = PointcutAttrs.values()) {
            currentAttr.addAtt(pc, current);
        }
        Node className = ExtensionDomParser.getChildNode(CLASS_NAME, current.getChildNodes());
        pc.setClassName(ExtensionDomParser.getTextContent(className));
        ArrayList<Method> toAddMethods = new ArrayList<Method>();
        pc.setMethod(toAddMethods);
        List<Node> methods = ExtensionDomParser.getChildNodes(METHOD, current.getChildNodes());
        for (Node currentMethod : methods) {
            Method toAddMethod = ExtensionDomParser.getMethod(currentMethod);
            if (toAddMethod == null) continue;
            toAddMethods.add(toAddMethod);
        }
        return pc;
    }

    private static String getTextContent(Node node) {
        String context;
        String toReturn = null;
        if (node != null && (context = node.getTextContent()) != null && !context.isEmpty()) {
            toReturn = context.trim();
        }
        return toReturn;
    }

    private static Method getMethod(Node currentMethod) {
        Method toAddMethod = new Method();
        Node name = ExtensionDomParser.getChildNode(METHOD_NAME, currentMethod.getChildNodes());
        toAddMethod.setName(ExtensionDomParser.getTextContent(name));
        Node params = ExtensionDomParser.getChildNode(METHOD_PARAMS, currentMethod.getChildNodes());
        ArrayList<String> paramTypes = new ArrayList<String>();
        if (params != null) {
            List<Node> types = ExtensionDomParser.getChildNodes(PARAM_TYPES, params.getChildNodes());
            for (Node t : types) {
                String type;
                if (t == null || (type = t.getTextContent()) == null) continue;
                paramTypes.add(type.trim());
            }
        }
        toAddMethod.setParameters(new MethodParameters(paramTypes));
        return toAddMethod;
    }

    private static List<Node> getChildNodes(String name, NodeList children) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node == null || !name.equals(node.getLocalName())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static Node getChildNode(String name, NodeList children) {
        List<Node> matchingNodes = ExtensionDomParser.getChildNodes(name, children);
        int size = matchingNodes.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return matchingNodes.get(0);
        }
        throw new RuntimeException(MessageFormat.format("There should only be one {0} node but there are {1}.", name, size));
    }
}

