/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.Config;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension {
    private final String name;
    private final Config configuration;
    private final boolean enabled;
    private final ClassLoader classloader;

    Extension(ClassLoader classloader, String name, Map<?, ?> configuration) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Extensions must have a name");
        }
        this.classloader = classloader;
        this.name = name;
        this.configuration = new Config(configuration);
        this.enabled = this.configuration.getProperty("enabled", true);
    }

    Extension(ClassLoader classloader, Map<?, ?> config) {
        this(classloader, (String)config.get("name"), config);
    }

    public final String getName() {
        return this.name;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public String toString() {
        return this.getName() + " Extension";
    }

    public final Config getConfiguration() {
        return this.configuration;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getVersion() {
        return this.configuration.getProperty("version", "n/a");
    }

    public double getVersionNumber() {
        try {
            return this.configuration.getProperty("version", 0.0);
        }
        catch (Exception e) {
            Agent.LOG.severe(MessageFormat.format("Extension \"{0}\" has an invalid version \"{1}\". The version should be a double.", this.getName(), this.getVersion()));
            return 0.0;
        }
    }
}

