/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.yaml.InstrumentationConstructor;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.org.yaml.snakeyaml.Loader;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCutConfig {
    private static String defaultMetricPrefix;
    private Yaml yaml;
    private final List<PointCut> pcList = new ArrayList<PointCut>();

    public static Collection<PointCut> getEnabledExtensionPointCuts(Collection<Extension> ymlExtensions) {
        ArrayList<PointCut> list = new ArrayList<PointCut>();
        for (Extension ext : ymlExtensions) {
            Object instrumentation;
            if (!ext.isEnabled() || (instrumentation = ext.getConfiguration().getProperty("instrumentation")) == null) continue;
            list.addAll(PointCutConfig.addInstrumentation(ext, instrumentation));
        }
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            for (PointCut pc : list.toArray(new PointCut[0])) {
                String msg;
                if (pc.isEnabled()) {
                    msg = MessageFormat.format("Extension instrumentation point: {0} {1}", pc.getClassMatcher(), pc.getMethodMatcher());
                    Agent.LOG.finest(msg);
                    continue;
                }
                msg = MessageFormat.format("Extension instrumentation point not enabled: {0} {1}", pc.getClassMatcher(), pc.getMethodMatcher());
                Agent.LOG.info(msg);
                list.remove(pc);
            }
        }
        return list;
    }

    private static Collection<PointCut> addInstrumentation(Extension ext, Object instrumentation) {
        if (instrumentation instanceof Map) {
            try {
                Map instrumentationMap = (Map)instrumentation;
                defaultMetricPrefix = (String)instrumentationMap.get("metric_prefix");
                defaultMetricPrefix = defaultMetricPrefix == null ? "Custom" : defaultMetricPrefix;
                Object pcConfig = instrumentationMap.get("pointcuts");
                PointCutFactory pcFactory = new PointCutFactory(ext.getClassLoader(), defaultMetricPrefix);
                return pcFactory.getPointCuts(pcConfig);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("An error occurred reading the pointcuts in extension {0} : {1}", ext.getName(), t.toString());
                Agent.LOG.severe(msg);
                Agent.LOG.log(Level.FINER, msg, t);
            }
        } else {
            String msg = MessageFormat.format("Extension {0} has an invalid instrumentation section. Please check the format of the file.", ext.getName());
            Agent.LOG.severe(msg);
        }
        return Collections.emptyList();
    }

    public PointCutConfig(File[] files) {
        if (null != files) {
            this.initYaml();
            for (File file : files) {
                try {
                    FileInputStream input = new FileInputStream(file);
                    this.loadYaml(input);
                    Agent.LOG.info(MessageFormat.format("Loaded custom instrumentation from {0}", file.getName()));
                }
                catch (FileNotFoundException e) {
                    Agent.LOG.warning(MessageFormat.format("Could not open instrumentation file {0}. Please check that the file exists and has the correct permissions. ", file.getPath()));
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.SEVERE, MessageFormat.format("Error loading YAML instrumentation from {0}. Please check the file's format.", file.getName()));
                    Agent.LOG.log(Level.FINER, "YAML error: ", e);
                }
            }
        }
    }

    public PointCutConfig(InputStream input) {
        this.initYaml();
        try {
            this.loadYaml(input);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, "Error loading YAML instrumentation");
            Agent.LOG.log(Level.FINER, "Error: ", e);
        }
    }

    private void initYaml() {
        InstrumentationConstructor constructor = new InstrumentationConstructor();
        Loader loader = new Loader(constructor);
        this.yaml = new Yaml(loader);
    }

    private void loadYaml(InputStream input) throws ParseException {
        if (null == input) {
            return;
        }
        Object config = this.yaml.load(input);
        PointCutFactory pcFactory = new PointCutFactory(this.getClass().getClassLoader(), "Custom");
        this.pcList.addAll(pcFactory.getPointCuts(config));
    }

    public List<PointCut> getPointCuts() {
        return this.pcList;
    }
}

