/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.INamedTransactionConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamedTransactionConfigImpl
implements INamedTransactionConfig {
    private final Map<String, Long> apdexTs;
    private final long apdexTInMillis;

    private NamedTransactionConfigImpl(Map<String, Object> props, long apdexTInMillis) {
        this.apdexTInMillis = apdexTInMillis;
        HashMap<String, Long> apdexTs = new HashMap<String, Long>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Object apdexT = entry.getValue();
            if (!(apdexT instanceof Number)) continue;
            Long apdexTinMillis = (long)(((Number)apdexT).doubleValue() * 1000.0);
            String txName = entry.getKey();
            apdexTs.put(txName, apdexTinMillis);
        }
        this.apdexTs = apdexTs.isEmpty() ? null : Collections.unmodifiableMap(apdexTs);
    }

    @Override
    public long getApdexTInMillis(String transactionName) {
        if (this.apdexTs == null) {
            return this.apdexTInMillis;
        }
        Long apdexT = this.apdexTs.get(transactionName);
        if (apdexT == null) {
            return this.apdexTInMillis;
        }
        return apdexT;
    }

    static INamedTransactionConfig createNamedTransactionConfig(Map<String, Object> settings, long apdexTInMillis) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new NamedTransactionConfigImpl(settings, apdexTInMillis);
    }
}

