/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.Config2;
import com.newrelic.agent.config.IErrorCollectorConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorCollectorConfigImpl
extends Config2
implements IErrorCollectorConfig {
    public static final String ENABLED = "enabled";
    public static final String COLLECT_ERRORS = "collect_errors";
    public static final String IGNORE_STATUS_CODES = "ignore_status_codes";
    public static final String IGNORE_ERRORS = "ignore_errors";
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_COLLECT_ERRORS = false;
    public static final Set<Integer> DEFAULT_IGNORE_STATUS_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(404)));
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.error_collector.";
    private final boolean isEnabled = this.initEnabled();
    private final Set<String> ignoreErrors = this.initIgnoreErrors();
    private final Set<Integer> ignoreStatusCodes = Collections.unmodifiableSet(this.getIntegerSet("ignore_status_codes", DEFAULT_IGNORE_STATUS_CODES));

    private ErrorCollectorConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
    }

    private Set<String> initIgnoreErrors() {
        Collection<String> uniqueErrors = this.getUniqueStrings(IGNORE_ERRORS);
        HashSet<String> result = new HashSet<String>(uniqueErrors.size());
        for (String uniqueError : uniqueErrors) {
            result.add(uniqueError.replace('/', '.'));
        }
        return Collections.unmodifiableSet(result);
    }

    private boolean initEnabled() {
        boolean isEnabled = this.getProperty(ENABLED, false);
        boolean canCollectErrors = this.getProperty(COLLECT_ERRORS, false);
        return isEnabled && canCollectErrors;
    }

    @Override
    public Set<String> getIgnoreErrors() {
        return this.ignoreErrors;
    }

    @Override
    public Set<Integer> getIgnoreStatusCodes() {
        return this.ignoreStatusCodes;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    static IErrorCollectorConfig createErrorCollectorConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ErrorCollectorConfigImpl(settings);
    }
}

