/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.SystemPropertyProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSystemPropertyProvider
implements SystemPropertyProvider {
    private static final String HEROKU_PREFIX = "NEW_RELIC_";
    private static final String HEROKU_LICENSE_KEY = "NEW_RELIC_LICENSE_KEY";
    private static final String HEROKU_APP_NAME = "NEW_RELIC_APP_NAME";
    private static final String HEROKU_LOG = "NEW_RELIC_LOG";
    private static final String LICENSE_KEY = "newrelic.config.license_key";
    private static final String APP_NAME = "newrelic.config.app_name";
    private static final String LOG_FILE_NAME = "newrelic.config.log_file_name";
    private static final String NEW_RELIC_SYSTEM_PROPERTY_ROOT = "newrelic.";
    private final Map<String, String> herokuEnvVars = this.initHerokuEnvVariables();
    private final Map<String, String> newRelicSystemProps = this.initNewRelicSystemProperties();

    private Map<String, String> initHerokuEnvVariables() {
        HashMap<String, String> herokuEnvVars = new HashMap<String, String>(3);
        herokuEnvVars.put(LICENSE_KEY, System.getenv().get(HEROKU_LICENSE_KEY));
        herokuEnvVars.put(APP_NAME, System.getenv().get(HEROKU_APP_NAME));
        herokuEnvVars.put(LOG_FILE_NAME, System.getenv().get(HEROKU_LOG));
        return herokuEnvVars;
    }

    private Map<String, String> initNewRelicSystemProperties() {
        Set<Map.Entry<Object, Object>> entries = System.getProperties().entrySet();
        HashMap<String, String> nrProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            if (!key.startsWith(NEW_RELIC_SYSTEM_PROPERTY_ROOT)) continue;
            nrProps.put(key, val);
        }
        return nrProps;
    }

    @Override
    public String getEnvironmentVariable(String prop) {
        String val = this.herokuEnvVars.get(prop);
        if (val != null) {
            return val;
        }
        return System.getenv().get(prop);
    }

    @Override
    public String getSystemProperty(String prop) {
        return System.getProperties().getProperty(prop);
    }

    @Override
    public Map<String, String> getNewRelicSystemProperties() {
        return this.newRelicSystemProps;
    }
}

