/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigFactory;
import com.newrelic.agent.config.AgentConfigHelper;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.config.IAgentConfigListener;
import com.newrelic.agent.config.IErrorCollectorConfig;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigServiceImpl
extends AbstractService
implements ConfigService,
ConnectionListener,
HarvestListener {
    private static final String SANITIZED_SETTING = "****";
    private final List<IAgentConfigListener> listeners2 = new CopyOnWriteArrayList<IAgentConfigListener>();
    private volatile AgentConfig config;
    private final File configFile;
    private final Map<String, Object> localSettings;
    private long lastModified;
    private final ConcurrentMap<String, IAgentConfig> agentConfigs = new ConcurrentHashMap<String, IAgentConfig>();
    private volatile IAgentConfig defaultAgentConfig;
    private volatile IAgentConfig localAgentConfig;
    private final String defaultAppName;

    protected ConfigServiceImpl(AgentConfig config, File configFile, Map<String, Object> localSettings) {
        super(ConfigService.class.getSimpleName());
        this.config = config;
        this.configFile = configFile;
        this.localSettings = Collections.unmodifiableMap(localSettings);
        this.defaultAgentConfig = this.localAgentConfig = AgentConfigFactory.createAgentConfig(localSettings, null);
        this.defaultAppName = this.defaultAgentConfig.getApplicationName();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        Object apdex_t;
        ServiceFactory.getRPMServiceManager().addConnectionListener(this);
        if (this.configFile != null) {
            this.lastModified = this.configFile.lastModified();
            String msg = MessageFormat.format("Configuration file is {0}", this.configFile.getAbsolutePath());
            this.getLogger().info(msg);
        }
        if ((apdex_t = this.config.getProperty("apdex_t", null)) != null) {
            String msg = "The apdex_t setting is obsolete and is ignored! Set the apdex_t value for an application in New Relic UI";
            this.getLogger().warning(msg);
        }
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void addIAgentConfigListener(IAgentConfigListener listener) {
        this.listeners2.add(listener);
    }

    @Override
    public void removeIAgentConfigListener(IAgentConfigListener listener) {
        this.listeners2.remove(listener);
    }

    @Override
    public Map<String, Object> getLocalSettings() {
        return this.localSettings;
    }

    @Override
    public Map<String, Object> getSanitizedLocalSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>(this.localSettings);
        if (settings.containsKey("proxy_user")) {
            settings.put("proxy_user", SANITIZED_SETTING);
        }
        if (settings.containsKey("proxy_password")) {
            settings.put("proxy_password", SANITIZED_SETTING);
        }
        return settings;
    }

    @Override
    public AgentConfig getAgentConfig() {
        return this.config;
    }

    @Override
    public IAgentConfig getDefaultAgentConfig() {
        return this.defaultAgentConfig;
    }

    @Override
    public IAgentConfig getLocalAgentConfig() {
        return this.localAgentConfig;
    }

    @Override
    public IAgentConfig getAgentConfig(String appName) {
        return this.getOrCreateAgentConfig(appName);
    }

    @Override
    public ITransactionTracerConfig getTransactionTracerConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getTransactionTracerConfig();
    }

    @Override
    public IErrorCollectorConfig getErrorCollectorConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getErrorCollectorConfig();
    }

    private void checkConfigFile() throws Exception {
        if (this.configFile.lastModified() == this.lastModified) {
            return;
        }
        Agent.LOG.info("Re-reading New Relic configuration file");
        this.lastModified = this.configFile.lastModified();
        Map<String, Object> settings = AgentConfigHelper.getConfigurationFileSettings(this.configFile);
        IAgentConfig agentConfig = this.createAgentConfig(this.defaultAppName, settings, null);
        if (!this.hasLocalConfigChanged(agentConfig)) {
            return;
        }
        Map<String, Object> settings2 = AgentConfigFactory.createMap(this.localSettings);
        settings2.put("audit_mode", agentConfig.isAuditMode());
        settings2.put("log_level", agentConfig.getLogLevel());
        this.localAgentConfig = AgentConfigFactory.createAgentConfig(settings2, null);
        AgentLogManager.setLogLevel(agentConfig.getLogLevel());
    }

    private boolean hasLocalConfigChanged(IAgentConfig agentConfig) {
        if (agentConfig == null) {
            return false;
        }
        if (agentConfig.isAuditMode() != this.localAgentConfig.isAuditMode()) {
            return true;
        }
        if (agentConfig.getLogLevel() == null) {
            return this.localAgentConfig.getLogLevel() != null;
        }
        return !agentConfig.getLogLevel().equals(this.localAgentConfig.getLogLevel());
    }

    private void notifyListeners2(String appName, IAgentConfig agentConfig) {
        for (IAgentConfigListener listener : this.listeners2) {
            listener.configChanged(appName, agentConfig);
        }
    }

    private IAgentConfig getOrCreateAgentConfig(String appName) {
        IAgentConfig agentConfig = this.findAgentConfig(appName);
        if (agentConfig != null) {
            return agentConfig;
        }
        agentConfig = AgentConfigFactory.createAgentConfig(this.localSettings, null);
        IAgentConfig oldAgentConfig = this.agentConfigs.putIfAbsent(appName, agentConfig);
        return oldAgentConfig == null ? agentConfig : oldAgentConfig;
    }

    private IAgentConfig findAgentConfig(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultAgentConfig;
        }
        return (IAgentConfig)this.agentConfigs.get(appName);
    }

    private IAgentConfig createAgentConfig(String appName, Map<String, Object> localSettings, Map<String, Object> serverData) {
        try {
            return AgentConfigFactory.createAgentConfig(localSettings, serverData);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error configuring application \"{0}\" with server data \"{1}\": {2}", appName, serverData, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.warning(msg);
            }
            return null;
        }
    }

    private void replaceServerConfig(String appName, Map<String, Object> serverData) {
        IAgentConfig agentConfig;
        if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer(MessageFormat.format("Received New Relic data for {0}: {1}", appName, serverData));
        }
        if ((agentConfig = this.createAgentConfig(appName, this.localSettings, serverData)) == null) {
            return;
        }
        if (appName == null || appName.equals(this.defaultAppName)) {
            this.defaultAgentConfig = agentConfig;
        } else {
            this.agentConfigs.put(appName, agentConfig);
        }
        if (agentConfig.getProperty("high_security") != null) {
            String msg = MessageFormat.format("The agent is in high security mode for {0}: {1} setting is \"{2}\". {3} setting is \"{4}\"", appName, "transaction_tracer.record_sql", agentConfig.getTransactionTracerConfig().getRecordSql(), "capture_params", agentConfig.isCaptureParams());
            Agent.LOG.info(msg);
        }
        this.notifyListeners2(appName, agentConfig);
    }

    @Override
    public void connected(IRPMService rpmService, Map<String, Object> serverData) {
        String appName = rpmService.getApplicationName();
        this.replaceServerConfig(appName, serverData);
    }

    @Override
    public void disconnected(IRPMService rpmService) {
    }

    @Override
    public void afterHarvest(String appName) {
        if (!appName.equals(this.defaultAppName)) {
            return;
        }
        try {
            this.checkConfigFile();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Unexpected exception checking for config file changes: {0}", t.toString());
            this.getLogger().warning(msg);
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }
}

