/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.org.json.simple.parser.JSONParser;
import com.newrelic.org.json.simple.parser.ParseException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config2 {
    public static final String COMMA_SEPARATOR = ",";
    public static final String SEMI_COLON_SEPARATOR = ";";
    private final Map<String, Object> props;
    protected final String systemPropertyPrefix;

    public Config2(Map<String, Object> props, String systemPropertyPrefix) {
        this.props = Collections.unmodifiableMap(props);
        this.systemPropertyPrefix = systemPropertyPrefix;
    }

    protected Map<String, Object> getProperties() {
        return this.props;
    }

    protected Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> nestedProps(String key) {
        Object value = this.getProperties().get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof ServerProp) {
            value = ((ServerProp)value).getValue();
        }
        if (Map.class.isInstance(value)) {
            return (Map)value;
        }
        String msg = MessageFormat.format("Agent configuration expected nested configuration values for \"{0}\", got \"{1}\"", key, value);
        Agent.LOG.warning(msg);
        return null;
    }

    protected Object getPropertyFromSystemProperties(String name, Object defaultVal) {
        String key = this.getSystemPropertyKey(name);
        String result = SystemPropertyFactory.getSystemPropertyProvider().getSystemProperty(key);
        return this.parseValue(key, result);
    }

    protected String getSystemPropertyKey(String key) {
        return this.systemPropertyPrefix == null ? key : this.systemPropertyPrefix + key;
    }

    protected Object getPropertyFromSystemEnvironment(String name, Object defaultVal) {
        String key = this.getSystemPropertyKey(name);
        String result = SystemPropertyFactory.getSystemPropertyProvider().getEnvironmentVariable(key);
        return this.parseValue(key, result);
    }

    protected Object parseValue(String name, String val) {
        if (val == null) {
            return val;
        }
        try {
            return new JSONParser().parse(val);
        }
        catch (ParseException e) {
            return val.toString();
        }
    }

    public <T> T getProperty(String key, T defaultVal) {
        Object propVal = this.getProperties().get(key);
        if (propVal instanceof ServerProp) {
            propVal = ((ServerProp)propVal).getValue();
            return this.castValue(key, propVal, defaultVal);
        }
        Object override = this.getPropertyFromSystemEnvironment(key, defaultVal);
        if (override != null) {
            return (T)override;
        }
        override = this.getPropertyFromSystemProperties(key, defaultVal);
        if (override != null) {
            return (T)override;
        }
        return this.castValue(key, propVal, defaultVal);
    }

    private <T> T castValue(String key, Object value, T defaultVal) {
        try {
            Object val = value;
            if (val == null) {
                return defaultVal;
            }
            if (val instanceof String) {
                return (T)((String)val).trim();
            }
            return (T)val;
        }
        catch (ClassCastException e) {
            return defaultVal;
        }
    }

    public <T> T getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected Set<Integer> getIntegerSet(String key, Set<Integer> defaultVal) {
        Object val = this.getProperty(key);
        if (val instanceof String) {
            return Collections.unmodifiableSet(this.getIntegerSetFromString((String)val));
        }
        if (val instanceof Collection) {
            return Collections.unmodifiableSet(this.getIntegerSetFromCollection((Collection)val));
        }
        if (val instanceof Integer) {
            return Collections.unmodifiableSet(this.getIntegerSetFromCollection(Arrays.asList((Integer)val)));
        }
        return defaultVal;
    }

    protected Set<Map<String, Object>> getMapSet(String key) {
        Object val = this.getProperty(key);
        if (val instanceof Collection) {
            return Collections.unmodifiableSet(this.getMapSetFromCollection((Collection)val));
        }
        return Collections.emptySet();
    }

    protected Set<Map<String, Object>> getMapSetFromCollection(Collection<?> values) {
        HashSet<Map<String, Object>> result = new HashSet<Map<String, Object>>(values.size());
        for (Object value : values) {
            result.add((Map)value);
        }
        return result;
    }

    protected String getFirstString(String key, String separator) {
        Collection values;
        Iterator i$;
        Object val = this.getProperty(key);
        if (val instanceof String) {
            String[] values2 = ((String)val).split(separator);
            if (values2.length == 0) {
                return null;
            }
            String res = values2[0].trim();
            if (res.length() == 0) {
                return null;
            }
            return res;
        }
        if (val instanceof Collection && (i$ = (values = (Collection)val).iterator()).hasNext()) {
            Object value = i$.next();
            String res = (String)value;
            if ((res = res.trim()).length() != 0) {
                return res;
            }
            return null;
        }
        return null;
    }

    protected Collection<String> getUniqueStrings(String key) {
        return this.getUniqueStrings(key, COMMA_SEPARATOR);
    }

    protected Collection<String> getUniqueStrings(String key, String separator) {
        Object val = this.getProperty(key);
        if (val instanceof String) {
            return Collections.unmodifiableList(Config2.getUniqueStringsFromString((String)val, separator));
        }
        if (val instanceof Collection) {
            return Collections.unmodifiableList(this.getUniqueStringsFromCollection((Collection)val));
        }
        return Collections.emptySet();
    }

    private List<String> getUniqueStringsFromCollection(Collection<?> values) {
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (Object value : values) {
            String val = null;
            val = value instanceof Integer ? String.valueOf(value) : (value instanceof Long ? String.valueOf(value) : (String)value);
            val = val.trim();
            if (val.length() == 0 || result.contains(val)) continue;
            result.add(val);
        }
        return result;
    }

    public static List<String> getUniqueStringsFromString(String valuesString, String separator) {
        String[] valuesArray = valuesString.split(separator);
        ArrayList<String> result = new ArrayList<String>(valuesArray.length);
        for (String value : valuesArray) {
            if ((value = value.trim()).length() == 0 || result.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    protected int getIntProperty(String key, int defaultVal) {
        Number val = (Number)this.getProperty(key);
        if (val == null) {
            return defaultVal;
        }
        return val.intValue();
    }

    protected double getDoubleProperty(String key, double defaultVal) {
        Number val = (Number)this.getProperty(key);
        if (val == null) {
            return defaultVal;
        }
        return val.doubleValue();
    }

    private Set<Integer> getIntegerSetFromCollection(Collection<?> values) {
        HashSet<Integer> result = new HashSet<Integer>(values.size());
        for (Object value : values) {
            int val = ((Number)value).intValue();
            result.add(val);
        }
        return result;
    }

    private Set<Integer> getIntegerSetFromString(String valuesString) {
        String[] valuesArray = valuesString.split(COMMA_SEPARATOR);
        HashSet<Integer> result = new HashSet<Integer>(valuesArray.length);
        for (String value : valuesArray) {
            if ((value = value.trim()).length() == 0) continue;
            result.add(Integer.parseInt(value));
        }
        return result;
    }
}

