/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.org.json.simple.parser.JSONParser;
import com.newrelic.org.json.simple.parser.ParseException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private final Map props;
    private final String systemPropertyRoot;
    private Map modifiableProps;

    public Config(Map props, String systemPropertyRoot) {
        if (props == null) {
            Agent.LOG.finer("Config object was initialized with null properties");
            props = Collections.emptyMap();
        }
        this.props = Collections.unmodifiableMap(props);
        this.modifiableProps = props;
        this.systemPropertyRoot = systemPropertyRoot;
    }

    public Config(Map props) {
        this(props, null);
    }

    public Map getProperties() {
        return this.props;
    }

    protected void setProperty(String key, Object value) {
        this.modifiableProps.put(key, value);
    }

    public Map<?, ?> nestedProps(String key) {
        Object value = this.getProperties().get(key);
        if (value != null && !Map.class.isInstance(value)) {
            String msg = MessageFormat.format("Agent configuration expected nested configuration values for \"{0}\", got \"{1}\"", key, value);
            throw new RuntimeException(msg);
        }
        return (Map)value;
    }

    public Map<String, String> nestedStringProps(String key) {
        Map<?, ?> appProps = this.nestedProps(key);
        if (appProps == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(appProps.size());
        for (Map.Entry<?, ?> entry : appProps.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) {
                String msg = MessageFormat.format("Agent configuration expected String value for entry key \"{0}\", got \"{1}\"", key, entry.getKey());
                throw new RuntimeException(msg);
            }
            String entryKey = (String)String.class.cast(entry.getKey());
            if (!String.class.isInstance(entry.getValue())) {
                String msg = MessageFormat.format("Agent configuration expected String value for entry value \"{0}\", got \"{1}\"", key, entry.getValue());
                throw new RuntimeException(msg);
            }
            String entryValue = (String)String.class.cast(entry.getValue());
            result.put(entryKey, entryValue);
        }
        return result;
    }

    private Object getPropertyFromSystemProperties(String name, Object defaultVal) {
        return this.getPropertyFromMap(name, defaultVal, System.getProperties());
    }

    protected Object getPropertyFromMap(String name, Object defaultVal, Map properties) {
        if (this.systemPropertyRoot == null) {
            return null;
        }
        try {
            String key = this.systemPropertyRoot + '.' + name;
            String val = (String)properties.get(key);
            if (val != null) {
                return Config.castValue(key, val, defaultVal);
            }
            return val;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Object getPropertyFromSystemEnvironment(String name, Object defaultVal) {
        return this.getPropertyFromMap(name, defaultVal, System.getenv());
    }

    private static Object castValue(String name, String val, Object defaultVal) {
        if (defaultVal instanceof String) {
            return val.toString();
        }
        try {
            return new JSONParser().parse(val);
        }
        catch (ParseException e) {
            String msg = MessageFormat.format("Unable to parse system property {0} with value {1} : {2}.", name, val, e.toString());
            Agent.LOG.finest(msg);
            return val.toString();
        }
    }

    public <T> T getProperty(String key, T defaultVal) {
        Object override = this.getPropertyFromSystemEnvironment(key, defaultVal);
        if (override != null) {
            return (T)override;
        }
        override = this.getPropertyFromSystemProperties(key, defaultVal);
        if (override != null) {
            return (T)override;
        }
        try {
            Object val = this.props.get(key);
            if (val == null) {
                return defaultVal;
            }
            if (val instanceof String) {
                return (T)((String)val).trim();
            }
            return (T)val;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Unable to parse configuration key/value: {0}/{1}", key, this.props.get(key));
            Agent.LOG.severe(msg);
            return defaultVal;
        }
    }

    public <T> T getProperty(String key) {
        return this.getProperty(key, null);
    }

    public Config getConfig(String key) {
        Map props = (Map)this.getProperty(key);
        if (props == null) {
            props = Collections.emptyMap();
        }
        return new Config(props);
    }
}

