/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.Config2;
import com.newrelic.agent.config.IClassTransformerConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassTransformerConfigImpl
extends Config2
implements IClassTransformerConfig {
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.class_transformer.";
    public static final String EXCLUDES = "excludes";
    public static final String INCLUDES = "includes";
    public static final String COMPUTE_FRAMES = "compute_frames";
    public static final boolean DEFAULT_COMPUTE_FRAMES = true;
    private final boolean custom_tracing;
    private final Set<String> excludes;
    private final Set<String> includes;
    private final boolean computeFrames;

    private ClassTransformerConfigImpl(Map<String, Object> props, boolean custom_tracing) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.custom_tracing = custom_tracing;
        this.excludes = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(EXCLUDES)));
        this.includes = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(INCLUDES)));
        this.computeFrames = this.getProperty(COMPUTE_FRAMES, true);
    }

    @Override
    public boolean isCustomTracingEnabled() {
        return this.custom_tracing;
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean computeFrames() {
        return this.computeFrames;
    }

    static IClassTransformerConfig createClassTransformerConfig(Map<String, Object> settings, boolean custom_tracing) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ClassTransformerConfigImpl(settings, custom_tracing);
    }
}

