/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.annotationmatchers.AnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.ClassNameAnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.NoMatchAnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.OrAnnotationMatcher;
import com.newrelic.org.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public final class ClassTransformerConfig
extends Config {
    public static final String EXCLUDES_PROPERTY = "excludes";
    public static final String INCLUDES_PROPERTY = "includes";
    public static final String JDBC_STATEMENTS_PROPERTY = "jdbc_statements";
    public static final String APP_CLASS_LOADERS_PROPERTY = "app_class_loaders";
    static final String NEW_RELIC_TRACE_TYPE_DESC = "Lcom/newrelic/api/agent/Trace;";
    static final String DEPRECATED_NEW_RELIC_TRACE_TYPE_DESC = "Lcom/newrelic/agent/Trace;";
    private final AnnotationMatcher ignoreTransactionAnnotationMatcher;
    private final AnnotationMatcher ignoreApdexAnnotationMatcher;
    private final AnnotationMatcher traceAnnotationMatcher;

    ClassTransformerConfig(boolean customTracingEnabled, Map props) {
        super(props, "newrelic.config.class_transformer");
        this.traceAnnotationMatcher = customTracingEnabled ? this.initializeTraceAnnotationMatcher(props) : new NoMatchAnnotationMatcher();
        this.ignoreTransactionAnnotationMatcher = new ClassNameAnnotationMatcher("NewRelicIgnoreTransaction", false);
        this.ignoreApdexAnnotationMatcher = new ClassNameAnnotationMatcher("NewRelicIgnoreApdex", false);
    }

    private AnnotationMatcher initializeTraceAnnotationMatcher(Map props) {
        ArrayList<AnnotationMatcher> matchers = new ArrayList<AnnotationMatcher>();
        matchers.add(new ClassNameAnnotationMatcher(Type.getType(DEPRECATED_NEW_RELIC_TRACE_TYPE_DESC).getDescriptor()));
        matchers.add(new ClassNameAnnotationMatcher(Type.getType(NEW_RELIC_TRACE_TYPE_DESC).getDescriptor()));
        String traceAnnotationClassName = (String)this.getProperty("trace_annotation_class_name");
        if (traceAnnotationClassName == null) {
            matchers.add(new ClassNameAnnotationMatcher("NewRelicTrace", false));
        } else {
            final HashSet<String> names = new HashSet<String>();
            for (String name : traceAnnotationClassName.split(",")) {
                names.add(ClassTransformerConfig.internalizeName(name));
            }
            matchers.add(new AnnotationMatcher(){

                public boolean matches(String annotationDesc) {
                    return names.contains(annotationDesc);
                }
            });
        }
        return OrAnnotationMatcher.getOrMatcher(matchers.toArray(new AnnotationMatcher[0]));
    }

    static String internalizeName(String name) {
        return 'L' + name.trim().replace('.', '/') + ';';
    }

    public AnnotationMatcher getTraceAnnotationMatcher() {
        return this.traceAnnotationMatcher;
    }

    public String[] getJdbcStatements() {
        String jdbcStatementsProp = (String)this.getProperty(JDBC_STATEMENTS_PROPERTY);
        if (jdbcStatementsProp == null) {
            return new String[0];
        }
        return jdbcStatementsProp.split(",[\\s]*");
    }

    public String[] getIncludes() {
        String includesProp = (String)this.getProperty(INCLUDES_PROPERTY);
        if (includesProp == null) {
            return new String[0];
        }
        return includesProp.split(",[\\s]*");
    }

    public String[] getExcludes() {
        String excludesProp = (String)this.getProperty(EXCLUDES_PROPERTY);
        if (excludesProp == null) {
            return new String[0];
        }
        return excludesProp.split(",[\\s]*");
    }

    public String[] getAppClassLoaders() {
        String appClassLoaders = (String)this.getProperty(APP_CLASS_LOADERS_PROPERTY);
        if (appClassLoaders == null) {
            return new String[0];
        }
        return appClassLoaders.split(",[\\s]*");
    }

    public final AnnotationMatcher getIgnoreTransactionAnnotationMatcher() {
        return this.ignoreTransactionAnnotationMatcher;
    }

    public final AnnotationMatcher getIgnoreApdexAnnotationMatcher() {
        return this.ignoreApdexAnnotationMatcher;
    }
}

