/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.errors.ExceptionHandlerSignature;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.org.yaml.snakeyaml.Loader;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import com.newrelic.org.yaml.snakeyaml.constructor.Construct;
import com.newrelic.org.yaml.snakeyaml.constructor.Constructor;
import com.newrelic.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.org.yaml.snakeyaml.nodes.SequenceNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfigHelper {
    public static final String NEWRELIC_ENVIRONMENT = "newrelic.environment";
    private static final String JAVA_ENVIRONMENT = "JAVA_ENV";
    private static final String PRODUCTION_ENVIRONMENT = "production";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getConfigurationFileSettings(File configFile) throws Exception {
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            Map<String, Object> map = AgentConfigHelper.parseConfiguration(is);
            return map;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Map<String, Object> parseConfiguration(InputStream is) throws Exception {
        String env = AgentConfigHelper.getEnvironment();
        try {
            Map allConfig = (Map)AgentConfigHelper.createYaml().load(is);
            if (allConfig == null) {
                Agent.LOG.info("The configuration file is empty");
                return Collections.emptyMap();
            }
            Map props = (Map)allConfig.get(env);
            if (props == null) {
                props = (Map)allConfig.get("common");
            }
            if (props == null) {
                throw new Exception(MessageFormat.format("Unable to find configuration named {0}", env));
            }
            return props;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, MessageFormat.format("Unable to parse configuration file. Please validate the yaml: {0}", e.toString()), e);
            throw e;
        }
    }

    private static String getEnvironment() {
        String env = System.getProperty(NEWRELIC_ENVIRONMENT);
        env = env == null ? System.getenv(JAVA_ENVIRONMENT) : env;
        return env == null ? PRODUCTION_ENVIRONMENT : env;
    }

    private static Yaml createYaml() {
        ExtensionConstructor constructor = new ExtensionConstructor();
        Loader loader = new Loader(constructor);
        return new Yaml(loader);
    }

    private static class ExtensionConstructor
    extends Constructor {
        public ExtensionConstructor() {
            this.yamlConstructors.put("!exception_handler", new Construct(){

                public Object construct(Node node) {
                    List args = ExtensionConstructor.this.constructSequence((SequenceNode)node);
                    try {
                        return new ExceptionHandlerSignature((String)args.get(0), (String)args.get(1), (String)args.get(2));
                    }
                    catch (InvalidMethodDescriptor e) {
                        return e;
                    }
                }
            });
        }
    }
}

