/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.AgentConfigImpl;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.transport.DataSenderWriter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfigFactory {
    public static final String AGENT_CONFIG = "agent_config";
    public static final String PERIOD_REGEX = "\\.";
    public static final String DOT_SEPARATOR = ".";
    public static final String SLOW_SQL_PREFIX = "slow_sql.";
    public static final String TRANSACTION_TRACER_PREFIX = "transaction_tracer.";
    public static final String TRANSACTION_TRACER_CATEGORY_BACKGROUND_PREFIX = "transaction_tracer.category.background.";
    public static final String TRANSACTION_TRACER_CATEGORY_REQUEST_PREFIX = "transaction_tracer.category.request.";
    public static final String ERROR_COLLECTOR_PREFIX = "error_collector.";
    public static final String THREAD_PROFILER_PREFIX = "thread_profiler.";
    public static final String HIGH_SECURITY = "high_security";
    public static final String COLLECT_ERRORS = "error_collector.collect_errors";
    public static final String COLLECT_TRACES = "transaction_tracer.collect_traces";
    public static final String RECORD_SQL = "transaction_tracer.record_sql";
    public static final String CROSS_APPLICATION_TRACER_PREFIX = "cross_application_tracer.";
    public static final String ENCODING_KEY = "cross_application_tracer.encoding_key";
    public static final String CROSS_PROCESS_ID = "cross_application_tracer.cross_process_id";
    public static final String TRUSTED_ACCOUNT_IDS = "cross_application_tracer.trusted_account_ids";

    public static IAgentConfig createAgentConfig(Map<String, Object> localSettings, Map<String, Object> serverData) {
        Map<String, Object> mergedSettings = AgentConfigFactory.createMap(localSettings);
        AgentConfigFactory.mergeServerData(mergedSettings, serverData);
        return AgentConfigImpl.createAgentConfig(mergedSettings);
    }

    public static Map<String, Object> getAgentData(Map<String, Object> serverData) {
        if (serverData == null) {
            return AgentConfigFactory.createMap();
        }
        Object agentData = serverData.get(AGENT_CONFIG);
        if (agentData == null || DataSenderWriter.nullValue().equals(agentData)) {
            return AgentConfigFactory.createMap();
        }
        return (Map)agentData;
    }

    private static void mergeServerData(Map<String, Object> settings, Map<String, Object> serverData) {
        if (serverData == null) {
            return;
        }
        Map<String, Object> agentData = AgentConfigFactory.getAgentData(serverData);
        agentData.remove("cross_application_tracing");
        AgentConfigFactory.mergeAgentData(settings, agentData);
        AgentConfigFactory.addServerProp("apdex_t", serverData.get("apdex_t"), settings);
        AgentConfigFactory.addServerProp(COLLECT_ERRORS, serverData.get("collect_errors"), settings);
        AgentConfigFactory.addServerProp(COLLECT_TRACES, serverData.get("collect_traces"), settings);
        AgentConfigFactory.addServerProp("web_transactions_apdex", serverData.get("web_transactions_apdex"), settings);
        AgentConfigFactory.addServerProp(CROSS_PROCESS_ID, serverData.get("cross_process_id"), settings);
        AgentConfigFactory.addServerProp(ENCODING_KEY, serverData.get("encoding_key"), settings);
        AgentConfigFactory.addServerProp(TRUSTED_ACCOUNT_IDS, serverData.get("trusted_account_ids"), settings);
        AgentConfigFactory.addServerProp("capture_params", serverData.get("capture_params"), settings);
        AgentConfigFactory.addServerProp(RECORD_SQL, serverData.get("record_sql"), settings);
        AgentConfigFactory.addServerProp(HIGH_SECURITY, serverData.get(HIGH_SECURITY), settings);
    }

    private static void mergeAgentData(Map<String, Object> settings, Map<String, Object> agentData) {
        for (Map.Entry<String, Object> entry : agentData.entrySet()) {
            AgentConfigFactory.addServerProp(entry.getKey(), entry.getValue(), settings);
        }
    }

    private static void addServerProp(String prop, Object val, Map<String, Object> settings) {
        String[] propArray;
        if (val == null) {
            return;
        }
        Map<String, Object> currentMap = settings;
        int count = 0;
        for (String propPart : propArray = prop.split(PERIOD_REGEX)) {
            if (++count < propArray.length) {
                Map<String, Object> propMap = (Map<String, Object>)currentMap.get(propPart);
                if (propMap == null) {
                    propMap = AgentConfigFactory.createMap();
                    currentMap.put(propPart, propMap);
                }
                currentMap = propMap;
                continue;
            }
            currentMap.put(propPart, ServerProp.createPropObject(val));
        }
    }

    private static Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> createMap(Map<String, Object> settings) {
        Map<String, Object> result = AgentConfigFactory.createMap();
        if (settings == null) {
            return result;
        }
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            AgentConfigFactory.putOrCreate(entry.getKey(), entry.getValue(), result);
        }
        return result;
    }

    private static void putOrCreate(String key, Object val, Map<String, Object> settings) {
        if (val instanceof Map) {
            settings.put(key, AgentConfigFactory.createMap((Map)val));
        } else {
            settings.put(key, val);
        }
    }
}

