/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.commands;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentMessage;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.Command;
import com.newrelic.agent.commands.RestartCommand;
import com.newrelic.agent.commands.ShutdownCommand;
import com.newrelic.agent.commands.UnknownCommand;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.JSONException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandParser
extends AbstractService
implements HarvestListener {
    private Map<String, Command> commands = new HashMap<String, Command>();
    private boolean enabled = true;

    public CommandParser() {
        super(CommandParser.class.getSimpleName());
    }

    public void addCommands(Command ... commands) {
        for (Command command : commands) {
            this.commands.put(command.getName(), command);
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        List<List<?>> commands;
        IRPMService rpmService = ServiceFactory.getRPMService(appName);
        try {
            commands = rpmService.getAgentCommands();
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Unable to get agent commands", e);
            return;
        }
        Map<Long, Object> commandResults = this.processCommands(rpmService, commands);
        try {
            rpmService.sendCommandResults(commandResults);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to send agent command feedback.  Command results: {0}", commandResults.toString());
            this.getLogger().fine(msg);
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    Command getCommand(String name) throws UnknownCommand {
        Agent.LOG.finer(MessageFormat.format("Process command \"{0}\"", name));
        Command c = this.commands.get(name);
        if (c == null) {
            throw new UnknownCommand("Unknown command " + name);
        }
        return c;
    }

    Map<Long, Object> processCommands(IRPMService rpmService, List<List<?>> commands) {
        HashMap<Long, Object> results = new HashMap<Long, Object>();
        int count = 0;
        for (List<?> agentCommand : commands) {
            if (agentCommand.size() == 2) {
                Object id = agentCommand.get(0);
                if (id instanceof Number) {
                    try {
                        Map commandMap = (Map)agentCommand.get(1);
                        String name = (String)commandMap.get("name");
                        Map args = (Map)commandMap.get("arguments");
                        if (args == null) {
                            args = Collections.EMPTY_MAP;
                        }
                        Command command = this.getCommand(name);
                        Map returnValue = command.process(rpmService, args);
                        results.put(((Number)id).longValue(), returnValue);
                        this.getLogger().finer(MessageFormat.format("Agent command \"{0}\" return value: {1}", name, returnValue));
                    }
                    catch (Exception e) {
                        this.getLogger().severe(MessageFormat.format("Unable to parse command : {0}", e.toString()));
                        this.getLogger().fine(MessageFormat.format("Unable to parse command", e));
                        results.put(((Number)id).longValue(), new JSONException(e));
                    }
                } else {
                    this.invalidCommand(rpmService, count, "Invalid command id " + id, agentCommand);
                }
            } else {
                this.invalidCommand(rpmService, count, "Unable to parse command", agentCommand);
            }
            ++count;
        }
        return results;
    }

    private void invalidCommand(IRPMService rpmService, int index, String message, List<?> agentCommand) {
        this.getLogger().severe(MessageFormat.format("Unable to parse command : {0} ({1})", message, agentCommand.toString()));
        AgentMessage agentMessage = new AgentMessage(message, "Command data: " + agentCommand.toString(), 2);
        rpmService.queueMessages(agentMessage);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() {
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        IAgent agent = ServiceFactory.getAgent();
        this.addCommands(new ShutdownCommand(agent), new RestartCommand());
        this.setEnabled(config);
        if (this.isEnabled()) {
            ServiceFactory.getHarvestService().addHarvestListener(this);
        } else {
            this.getLogger().log(Level.CONFIG, "The command parser is disabled");
        }
    }

    private void setEnabled(IAgentConfig agentConfig) {
        try {
            Map props = (Map)agentConfig.getProperty("command_parser");
            if (props != null) {
                Boolean enabled = (Boolean)props.get("enabled");
                this.enabled = enabled != null && enabled != false;
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Unable to parse the command_parser section in newrelic.yml");
        }
    }

    @Override
    protected void doStop() {
    }
}

