/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.command;

import com.newrelic.agent.command.MethodHolder;
import com.newrelic.agent.command.XmlInstrumentOptions;
import com.newrelic.agent.command.XmlInstrumentParams;
import com.newrelic.agent.extension.beans.Extension;
import com.newrelic.agent.extension.beans.Instrumentation;
import com.newrelic.agent.extension.beans.Pointcut;
import com.newrelic.agent.extension.dom.ExtensionDomParser;
import com.newrelic.agent.extension.util.ExtensionConversionUtility;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.org.apache.commons.cli.CommandLine;
import com.newrelic.org.objectweb.asm.Type;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.xml.sax.SAXException;

public class XmlInstrumentValidator {
    public static void validateInstrumentation(CommandLine cmd) {
        XmlInstrumentParams params = new XmlInstrumentParams();
        if (cmd == null) {
            XmlInstrumentValidator.printMessage("There were no command line parameters.");
        } else {
            try {
                if (XmlInstrumentValidator.verifyAndSetParameters(cmd, params)) {
                    XmlInstrumentValidator.validateInstrumentation(params);
                    XmlInstrumentValidator.printMessage(MessageFormat.format("PASS: The extension at {0} was successfully validated.", params.getFile().getAbsoluteFile()));
                }
            }
            catch (IOException e) {
                XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The extension at {0} failed validation. \nReason: {1} \nNOTE: set debug to true for more information.", params.getFile().getAbsoluteFile(), e.getMessage()));
            }
            catch (SAXException e) {
                XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The extension at {0} failed validation. \nReason: {1} \nNOTE: set debug to true for more information.", params.getFile().getAbsoluteFile(), e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                File file = params.getFile();
                String fileName = null;
                if (file != null) {
                    fileName = file.getAbsolutePath();
                }
                XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The extension at {0} failed validation. \n Reason: {1} \n Note: Set debug to true for more information.", fileName, e.getMessage()));
            }
            catch (RuntimeException e) {
                XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The extension at {0} failed validation. \n Reason: {1} \n Note: Set debug to true for more information.", params.getFile().getAbsoluteFile(), e.getMessage()));
            }
            catch (ClassNotFoundException e) {
                XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The extension at {0} failed validation. \n Reason: The following class was not found: {1} \n Note: Set debug to true for more information.", params.getFile().getAbsoluteFile(), e.getMessage()));
            }
            catch (Exception e) {
                XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The extension at {0} failed validation. \n Reason: {1} \n Note: Set debug to true for more information.", params.getFile().getAbsoluteFile(), e.getMessage()));
            }
        }
    }

    protected static void validateInstrumentation(XmlInstrumentParams params) throws ClassNotFoundException, RuntimeException, IllegalArgumentException, SAXException, IOException {
        Extension extension = ExtensionDomParser.readFile(params.getFile());
        if (params.isDebug()) {
            System.out.println("Xml was successfully read. Starting processing.");
        }
        List<PointCut> convertedPcs = ExtensionConversionUtility.convertToPointCutsForValidation(extension);
        Instrumentation inst = extension.getInstrumentation();
        if (inst == null) {
            throw new RuntimeException("The instrumentation propery must be set for the extension.");
        }
        List<Pointcut> origPcs = inst.getPointcut();
        if (convertedPcs.size() != origPcs.size()) {
            throw new IllegalArgumentException("The processed number of point cuts does not match theoriginal number of point cuts in the xml. Remove duplicates.");
        }
        for (int i = 0; i < convertedPcs.size(); ++i) {
            MethodHolder holder = XmlInstrumentValidator.sortData(origPcs.get(i), params.isDebug());
            XmlInstrumentValidator.verifyPointCut(convertedPcs.get(i), holder);
            XmlInstrumentValidator.verifyAllMethodsAccounted(holder);
        }
    }

    private static boolean verifyAndSetParameters(CommandLine cmd, XmlInstrumentParams params) throws IllegalArgumentException {
        try {
            XmlInstrumentOptions[] options;
            for (XmlInstrumentOptions ops : options = XmlInstrumentOptions.values()) {
                ops.validateAndAddParameter(params, cmd.getOptionValues(ops.getFlagName()), ops.getFlagName());
            }
            return true;
        }
        catch (Exception e) {
            XmlInstrumentValidator.printMessage(MessageFormat.format("FAIL: The command line parameters are invalid. \n Reason: {1}", e.getMessage()));
            return false;
        }
    }

    private static void verifyAllMethodsAccounted(MethodHolder originals) {
        if (originals.hasMethods()) {
            throw new IllegalArgumentException(MessageFormat.format("These methods are either duplicates, constructors, or are not present in the class: {0}", originals.getCurrentMethods()));
        }
    }

    private static void verifyPointCut(PointCut cut, MethodHolder origMethods) throws ClassNotFoundException {
        if (cut != null) {
            Collection<String> classNames = cut.getClassMatcher().getClassNames();
            for (String name : classNames) {
                String nameDoted = name.replace("/", ".").trim();
                Class<?> theClass = Class.forName(nameDoted);
                XmlInstrumentValidator.validateNoInterface(theClass);
                XmlInstrumentValidator.checkMethods(cut.getMethodMatcher(), theClass.getDeclaredMethods(), origMethods);
            }
        }
    }

    private static void validateNoInterface(Class theClass) {
        if (theClass.isInterface()) {
            throw new IllegalArgumentException(MessageFormat.format("Only classes can be implemented. This class is an interface: {0}", theClass.getName()));
        }
    }

    private static void checkMethods(MethodMatcher matcher, Method[] classMethods, MethodHolder origMethods) {
        if (classMethods != null) {
            if (origMethods == null) {
                throw new IllegalArgumentException("Instrumenting a class not found in the XML.");
            }
            for (Method m : classMethods) {
                String currentDesc = Type.getMethodDescriptor(m);
                XmlInstrumentValidator.checkPresenceAndMatcher(m.getName(), currentDesc, matcher, origMethods);
            }
        }
    }

    private static void checkPresenceAndMatcher(String currentName, String currentDesc, MethodMatcher matcher, MethodHolder origMethods) {
        if (origMethods.isMethodPresent(currentName, currentDesc, true) && !matcher.matches(currentName, currentDesc)) {
            throw new IllegalArgumentException(MessageFormat.format("The method was in the point cut but did not match the method matcher. Name: {0} Desc: {1}", currentName, currentDesc));
        }
    }

    private static MethodHolder sortData(Pointcut pc, boolean debug) {
        MethodHolder cMethods = new MethodHolder(debug);
        if (pc != null) {
            cMethods.addMethods(pc.getMethod());
        }
        return cMethods;
    }

    protected static void printMessage(String msg) {
        System.out.println(msg);
    }
}

