/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.beacon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.beacon.BeaconTransactionState;
import com.newrelic.agent.beacon.IBeaconConfig;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.WebRequestDispatcher;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeaconTransactionStateImpl
implements BeaconTransactionState {
    private static final String NRAGENT_COOKIE = "NRAGENT";
    private static final String NRAGENT_TOKEN_PREFIX = "tk";
    private static final String NRAGENT_TOKEN_PREFIX_PLUS_EQUALS = "tk=";
    private static final String NRAGENT_TOKEN_REGEX = "tk=([^\"<'>]+)";
    private static final Pattern NRAGENT_TOKEN_PATTERN = Pattern.compile("tk=([^\"<'>]+)");
    private static final String NRAGENT_COOKIE_HEADER_REGEX = "NRAGENT=(tk=[^;]+)";
    private static final Pattern NRAGENT_COOKIE_HEADER_PATTERN = Pattern.compile("NRAGENT=(tk=[^;]+)");
    private static final String COOKIE_HEADER_NAME = "Cookie";
    private final ITransaction tx;
    private boolean browserHeaderRendered;
    private boolean browserFooterRendered;
    private String userName;
    private String accountName;
    private String productName;
    private String guid;
    private String traceToken;
    private long duration = -1L;

    private BeaconTransactionStateImpl(ITransaction tx) {
        this.tx = tx;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String name) {
        this.accountName = name;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String name) {
        this.productName = name;
    }

    public String getBrowserTimingHeaderForJsp() {
        if (!this.canRenderHeaderForJsp()) {
            return "";
        }
        return this.getBrowserTimingHeader2();
    }

    public String getBrowserTimingHeader() {
        if (!this.canRenderHeader()) {
            return "";
        }
        return this.getBrowserTimingHeader2();
    }

    private String getBrowserTimingHeader2() {
        IBeaconConfig config = this.getBeaconConfig();
        if (config == null) {
            Agent.LOG.finer("Real user monitoring is disabled");
            return "";
        }
        String header = config.getBrowserTimingHeader();
        this.browserHeaderRendered = true;
        return header;
    }

    public String getBrowserTimingFooter() {
        if (!this.canRenderFooter()) {
            return "";
        }
        return this.getBrowserTimingFooter2();
    }

    private String getBrowserTimingFooter2() {
        IBeaconConfig config = this.getBeaconConfig();
        if (config == null) {
            Agent.LOG.finer("Real user monitoring is disabled");
            return "";
        }
        this.tx.freezeTransactionName();
        if (this.tx.isIgnore()) {
            Agent.LOG.finer("Unable to get browser timing footer: transaction is ignore");
            return "";
        }
        String footer = config.getBrowserTimingFooter(this);
        this.browserFooterRendered = true;
        return footer;
    }

    private boolean canRenderHeader() {
        if (this.tx.getLastTracer() == null) {
            Agent.LOG.finer("Unable to get browser timing header: transaction has no tracers");
            return false;
        }
        if (this.tx.isIgnore()) {
            Agent.LOG.finer("Unable to get browser timing header: transaction is ignore");
            return false;
        }
        if (this.browserHeaderRendered) {
            Agent.LOG.finer("browser timing header already rendered");
            return false;
        }
        return true;
    }

    private boolean canRenderHeaderForJsp() {
        if (!this.canRenderHeader()) {
            return false;
        }
        Dispatcher dispatcher = this.tx.getDispatcher();
        if (!(dispatcher instanceof WebRequestDispatcher)) {
            Agent.LOG.finer("Unable to get browser timing header: transaction is not a web transaction");
            return false;
        }
        try {
            String contentType = ((WebRequestDispatcher)dispatcher).getResponse()._nr_getContentType();
            if (!this.isHtml(contentType)) {
                String msg = MessageFormat.format("Unable to inject browser timing header in a JSP: bad content type: {0}", contentType);
                Agent.LOG.finer(msg);
                return false;
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to inject browser timing header in a JSP: exception getting content type: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return false;
        }
        return true;
    }

    private boolean isHtml(String contentType) {
        return contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("text/xhtml"));
    }

    private boolean canRenderFooter() {
        if (this.tx.getLastTracer() == null) {
            Agent.LOG.finer("Unable to get browser timing footer: transaction has no tracers");
            return false;
        }
        if (this.tx.isIgnore()) {
            Agent.LOG.finer("Unable to get browser timing footer: transaction is ignore");
            return false;
        }
        if (this.browserFooterRendered) {
            Agent.LOG.finer("browser timing footer already rendered");
            return false;
        }
        if (this.browserHeaderRendered) {
            return true;
        }
        IBeaconConfig config = this.getBeaconConfig();
        if (config == null) {
            Agent.LOG.finer("Real user monitoring is disabled");
            return false;
        }
        Agent.LOG.finer("getBrowserTimingFooter() was invoked without a call to getBrowserTimingHeader()");
        return false;
    }

    private IBeaconConfig getBeaconConfig() {
        String appName = this.tx.getApplicationName();
        return ServiceFactory.getBeaconService().getBeaconConfig(appName);
    }

    public String getTraceToken() {
        if (this.traceToken == null) {
            String token = this.getTraceToken2();
            this.traceToken = token == null ? "" : token;
        }
        return this.traceToken;
    }

    private String getTraceToken2() {
        String cookieValue = this.getNRAGENTCookieValue();
        if (cookieValue == null) {
            return null;
        }
        Matcher matcher = NRAGENT_TOKEN_PATTERN.matcher(cookieValue);
        if (matcher.matches()) {
            String group = matcher.group(1);
            if (cookieValue.length() == group.length() + NRAGENT_TOKEN_PREFIX_PLUS_EQUALS.length()) {
                return group;
            }
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Invalid trace token: {0}", cookieValue);
            Agent.LOG.finer(msg);
        }
        return null;
    }

    private String getNRAGENTCookieValue() {
        Dispatcher dispatcher = this.tx.getDispatcher();
        if (dispatcher == null) {
            return null;
        }
        String cookieValue = dispatcher.getCookieValue(NRAGENT_COOKIE);
        if (cookieValue == null) {
            return null;
        }
        if (!NRAGENT_TOKEN_PREFIX.equals(cookieValue)) {
            return cookieValue;
        }
        String header = dispatcher.getHeader(COOKIE_HEADER_NAME);
        if (header == null) {
            return null;
        }
        Matcher matcher = NRAGENT_COOKIE_HEADER_PATTERN.matcher(header);
        if (matcher.find()) {
            String group = matcher.group(1);
            return group;
        }
        return null;
    }

    public long getDurationInMilliseconds() {
        if (this.duration == -1L) {
            this.duration = TimeUnit.MILLISECONDS.convert(this.tx.getRunningDurationInNanos(), TimeUnit.NANOSECONDS);
        }
        return this.duration;
    }

    public long getExternalTimeInMilliseconds() {
        return this.tx.getExternalTime();
    }

    private long getApdexTInMillis() {
        String txName = this.getTransactionName();
        return this.tx.getAgentConfig().getApdexTInMillis(txName);
    }

    public String getGuid() {
        return this.guid;
    }

    public String getOrCreateGuid() {
        if (this.guid == null && this.shouldCreateGuid()) {
            this.guid = this.tx.getCrossProcessTransactionState().getGuid();
            if (this.guid == null) {
                this.guid = this.createGuid();
            }
        }
        return this.guid;
    }

    private boolean shouldCreateGuid() {
        if (this.getDurationInMilliseconds() <= this.getApdexTInMillis()) {
            return false;
        }
        String traceToken = this.getTraceToken();
        return traceToken != null && traceToken.length() != 0;
    }

    private String createGuid() {
        return ServiceFactory.getTransactionTraceService().generateBeaconGuid();
    }

    public String getTransactionName() {
        return this.tx.getPriorityTransactionName().getName();
    }

    public static BeaconTransactionState create(ITransaction tx) {
        return tx == null ? null : new BeaconTransactionStateImpl(tx);
    }
}

