/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.beacon;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.beacon.BeaconConfigFactory;
import com.newrelic.agent.beacon.BeaconService;
import com.newrelic.agent.beacon.IBeaconConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeaconServiceImpl
extends AbstractService
implements BeaconService,
ConnectionListener {
    private final ConcurrentMap<String, IBeaconConfig> beaconConfigs = new ConcurrentHashMap<String, IBeaconConfig>();
    private volatile IBeaconConfig defaultBeaconConfig = null;
    private final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();

    public BeaconServiceImpl() {
        super(BeaconService.class.getSimpleName());
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getRPMServiceManager().addConnectionListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
    }

    @Override
    public IBeaconConfig getBeaconConfig(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultBeaconConfig;
        }
        return (IBeaconConfig)this.beaconConfigs.get(appName);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void connected(IRPMService rpmService, Map<String, Object> serverData) {
        String appName = rpmService.getApplicationName();
        IBeaconConfig beaconConfig = BeaconConfigFactory.createBeaconConfig(appName, serverData);
        if (appName == null || appName.equals(this.defaultAppName)) {
            this.defaultBeaconConfig = beaconConfig;
        } else if (beaconConfig == null) {
            this.beaconConfigs.remove(appName);
        } else {
            this.beaconConfigs.put(appName, beaconConfig);
        }
    }

    @Override
    public void disconnected(IRPMService rpmService) {
    }
}

