/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.beacon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.beacon.BeaconConfig;
import com.newrelic.agent.beacon.IBeaconConfig;
import com.newrelic.agent.config.AgentConfigFactory;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeaconConfigFactory {
    public static IBeaconConfig createBeaconConfig(String appName, Map<String, Object> serverData) {
        try {
            IBeaconConfig beaconConfig = BeaconConfigFactory.createBeaconConfig(serverData);
            IAgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
            String autoInstrument = agentConfig.getBrowserMonitoringConfig().isAutoInstrumentEnabled() ? " with auto instrumentation" : "";
            String msg = MessageFormat.format("Real user monitoring is enabled{0} for application \"{1}\"", autoInstrument, appName);
            Agent.LOG.info(msg);
            return beaconConfig;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to configure application \"{0}\" for Real User Monitoring: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else {
                Agent.LOG.finer(msg);
            }
            Agent.LOG.info(MessageFormat.format("Real user monitoring is not enabled for application \"{0}\"", appName));
            return null;
        }
    }

    private static IBeaconConfig createBeaconConfig(Map<String, Object> serverData) throws Exception {
        Map<String, Object> settings = BeaconConfigFactory.createMap();
        BeaconConfigFactory.mergeBeaconSettings(settings, serverData);
        Map<String, Object> agentData = AgentConfigFactory.getAgentData(serverData);
        BeaconConfigFactory.mergeBeaconSettings(settings, agentData);
        return BeaconConfig.createBeaconConfig(settings);
    }

    private static void mergeBeaconSettings(Map<String, Object> settings, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        Object val = data.get("episodes_file");
        if (val != null) {
            settings.put("episodes_file", val);
        }
        if ((val = data.get("rum.load_episodes_file")) != null) {
            settings.put("rum.load_episodes_file", val);
        }
        if ((val = data.get("beacon")) != null) {
            settings.put("beacon", val);
        }
        if ((val = data.get("browser_key")) != null) {
            settings.put("browser_key", val);
        }
        if ((val = data.get("application_id")) != null) {
            settings.put("application_id", val);
        }
        if ((val = data.get("rum.jsonp")) != null) {
            settings.put("rum.jsonp", val);
        }
    }

    private static Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }
}

