/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.application;

import com.newrelic.agent.application.ApplicationNamePriority;
import com.newrelic.agent.config.Config2;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityApplicationName {
    public static final PriorityApplicationName NONE = PriorityApplicationName.create(null, ApplicationNamePriority.NONE);
    private final ApplicationNamePriority priority;
    private final String name;
    private final List<String> names;

    private PriorityApplicationName(String name, ApplicationNamePriority priority) {
        this.priority = priority;
        if (name == null) {
            this.name = null;
            this.names = null;
        } else {
            this.names = Collections.unmodifiableList(Config2.getUniqueStringsFromString(name, ";"));
            this.name = this.names.get(0);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNames() {
        return this.names;
    }

    public ApplicationNamePriority getPriority() {
        return this.priority;
    }

    public String toString() {
        return MessageFormat.format("{0}[name={1}, priority={2}]", new Object[]{this.getClass().getName(), this.getName(), this.getPriority()});
    }

    public static PriorityApplicationName create(String name, ApplicationNamePriority priority) {
        return new PriorityApplicationName(name, priority);
    }
}

