/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.application;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.ApplicationNamePriority;
import com.newrelic.agent.application.ApplicationNamingPolicy;
import com.newrelic.agent.application.HigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.application.SameOrHigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ApplicationNameUtils {
    private static final String FORWARD_SLASH = "/";

    private ApplicationNameUtils() {
    }

    public static void setAppNameForFilter(Transaction transaction, Object filterConfig) throws Exception {
        if (!transaction.isAutoAppNamingEnabled()) {
            return;
        }
        HigherPriorityApplicationNamingPolicy policy = HigherPriorityApplicationNamingPolicy.getInstance();
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.FILTER_INIT_PARAM)) {
            return;
        }
        ServletService servletService = ServiceFactory.getServletService();
        String initParam = servletService.getInitParamForFilterConfig(filterConfig, "com.newrelic.agent.APPLICATION_NAME");
        if (initParam != null && initParam.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting application name to \"{0}\" using filter init parameter", initParam);
                Agent.LOG.finer(msg);
            }
            ApplicationNameUtils.setAppName(transaction, initParam, policy, ApplicationNamePriority.FILTER_INIT_PARAM);
            return;
        }
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.CONTEXT_PARAM)) {
            return;
        }
        Object servletContext = servletService.getServletContextForFilterConfig(filterConfig);
        ApplicationNameUtils.setAppNameForServletContext(transaction, servletContext);
    }

    public static void setAppNameForServlet(Transaction transaction, Object servlet) throws Exception {
        Object servletConfig;
        if (!transaction.isAutoAppNamingEnabled()) {
            return;
        }
        HigherPriorityApplicationNamingPolicy policy = HigherPriorityApplicationNamingPolicy.getInstance();
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.SERVLET_INIT_PARAM)) {
            return;
        }
        ServletService servletService = ServiceFactory.getServletService();
        String initParam = servletService.getInitParamForServletConfig(servletConfig = servletService.getServletConfigForServlet(servlet), "com.newrelic.agent.APPLICATION_NAME");
        if (initParam != null && initParam.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting application name to \"{0}\" using servlet init parameter", initParam);
                Agent.LOG.finer(msg);
            }
            ApplicationNameUtils.setAppName(transaction, initParam, policy, ApplicationNamePriority.SERVLET_INIT_PARAM);
            return;
        }
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.CONTEXT_PARAM)) {
            return;
        }
        Object servletContext = servletService.getServletContextForServletConfig(servletConfig);
        ApplicationNameUtils.setAppNameForServletContext(transaction, servletContext);
    }

    public static void setAppNameForRequestAttribute(String name, Transaction transaction) {
        if (!transaction.isAutoAppNamingEnabled()) {
            return;
        }
        if (name == null || name.length() == 0) {
            return;
        }
        SameOrHigherPriorityApplicationNamingPolicy policy = SameOrHigherPriorityApplicationNamingPolicy.getInstance();
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.REQUEST_ATTRIBUTE)) {
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Setting application name to \"{0}\" using request attribute", name);
            Agent.LOG.finer(msg);
        }
        ApplicationNameUtils.setAppName(transaction, name, policy, ApplicationNamePriority.REQUEST_ATTRIBUTE);
    }

    private static void setAppNameForServletContext(Transaction transaction, Object servletContext) throws Exception {
        String msg;
        HigherPriorityApplicationNamingPolicy policy = HigherPriorityApplicationNamingPolicy.getInstance();
        ServletService servletService = ServiceFactory.getServletService();
        String appName = servletService.getInitParamForServletContext(servletContext, "com.newrelic.agent.APPLICATION_NAME");
        if (appName != null && appName.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                msg = MessageFormat.format("Setting application name to \"{0}\" using context parameter", appName);
                Agent.LOG.finer(msg);
            }
            ApplicationNameUtils.setAppName(transaction, appName, policy, ApplicationNamePriority.CONTEXT_PARAM);
        }
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.CONTEXT_NAME)) {
            return;
        }
        appName = servletService.getServletContextNameForServletContext(servletContext);
        if (appName != null && appName.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                msg = MessageFormat.format("Setting application name to \"{0}\" using context name", appName);
                Agent.LOG.finer(msg);
            }
            ApplicationNameUtils.setAppName(transaction, appName, policy, ApplicationNamePriority.CONTEXT_NAME);
            return;
        }
        if (!policy.canSetApplicationName(transaction, ApplicationNamePriority.CONTEXT_PATH)) {
            return;
        }
        appName = servletService.getContextPathForServletContext(servletContext);
        if (appName != null && appName.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                msg = MessageFormat.format("Setting application name to \"{0}\" using context path", appName);
                Agent.LOG.finer(msg);
            }
            ApplicationNameUtils.setAppName(transaction, appName, policy, ApplicationNamePriority.CONTEXT_PATH);
        }
    }

    private static void setAppName(Transaction transaction, String name, ApplicationNamingPolicy policy, ApplicationNamePriority priority) {
        String appName = ApplicationNameUtils.stripLeadingForwardSlash(name);
        policy.setApplicationName(transaction, appName, priority);
    }

    private static String stripLeadingForwardSlash(String appName) {
        if (appName.length() > 1 && appName.startsWith(FORWARD_SLASH)) {
            return appName.substring(1, appName.length());
        }
        return appName;
    }
}

