/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.transaction.MergeStatsEngineResolvingScope;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionService
extends AbstractService
implements HarvestListener {
    private static final ThreadLocal<Boolean> NOTICE_REQUEST_THREAD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<Boolean> NOTICE_BACKGROUND_THREAD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final List<TransactionListener> transactionListeners = new CopyOnWriteArrayList<TransactionListener>();
    private final Map<Long, Transaction> transactionThreadMap = new ConcurrentHashMap<Long, Transaction>();

    public TransactionService() {
        super(TransactionService.class.getSimpleName());
    }

    public static void noticeRequestThread(long threadId) {
        if (NOTICE_REQUEST_THREAD.get().booleanValue()) {
            return;
        }
        ServiceFactory.getThreadService().noticeRequestThread(threadId);
        NOTICE_REQUEST_THREAD.set(Boolean.TRUE);
    }

    public static void noticeBackgroundThread(long threadId) {
        if (NOTICE_BACKGROUND_THREAD.get().booleanValue()) {
            return;
        }
        ServiceFactory.getThreadService().noticeBackgroundThread(threadId);
        NOTICE_BACKGROUND_THREAD.set(Boolean.TRUE);
    }

    public void processTransaction(TransactionData transactionData, TransactionStats transactionStats) {
        try {
            this.doProcessTransaction(transactionData, transactionStats);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error recording transaction \"{0}\": {1}", transactionData.getBlameMetricName(), e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().warning(msg);
        }
    }

    private void doProcessTransaction(TransactionData transactionData, TransactionStats transactionStats) {
        if (!ServiceFactory.getServiceManager().isStarted() || !ServiceFactory.getAgent().isEnabled()) {
            return;
        }
        if (Agent.isDebugEnabled()) {
            this.getLogger().finer("Recording metrics for " + transactionData);
        }
        String transactionSizeMetric = "Supportability/TransactionSize";
        boolean sizeLimitExceeded = transactionData.getParameters().get("size_limit") != null;
        transactionStats.getUnscopedStats().getStats(transactionSizeMetric).recordDataPoint(transactionData.getTransactionSize());
        if (sizeLimitExceeded) {
            transactionStats.getUnscopedStats().getStats("Supportability/TransactionSizeClamp").incrementCallCount();
        }
        if (transactionData.isWebTransaction()) {
            TransactionService.noticeRequestThread(transactionData.getThreadId());
        } else {
            TransactionService.noticeBackgroundThread(transactionData.getThreadId());
        }
        if (transactionData.getRootTracer() instanceof DispatcherTracer) {
            for (TransactionListener listener : this.transactionListeners) {
                listener.dispatcherTransactionFinished(transactionData, transactionStats);
            }
        } else if (Agent.isDebugEnabled()) {
            this.getLogger().finer("Skipping transaction trace for " + transactionData);
        }
        StatsService statsService = ServiceFactory.getStatsService();
        MergeStatsEngineResolvingScope statsWork = new MergeStatsEngineResolvingScope(transactionData.getBlameMetricName(), transactionData.getApplicationName(), transactionStats);
        statsService.doStatsWork(statsWork);
    }

    @Override
    protected void doStart() {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        this.transactionListeners.clear();
        this.transactionThreadMap.clear();
    }

    public void addTransaction(Transaction tx) {
        long id = Thread.currentThread().getId();
        this.transactionThreadMap.put(id, tx);
    }

    public void removeTransaction() {
        this.transactionThreadMap.remove(Thread.currentThread().getId());
    }

    public Set<Long> getRunningThreadsIds() {
        HashSet<Long> runningThreadIds = new HashSet<Long>();
        for (Map.Entry<Long, Transaction> entry : this.transactionThreadMap.entrySet()) {
            Transaction tx = entry.getValue();
            if (tx.getRootTracer() == null) continue;
            runningThreadIds.add(entry.getKey());
        }
        return runningThreadIds;
    }

    public Set<Long> getThreadsIds() {
        return new HashSet<Long>(this.transactionThreadMap.keySet());
    }

    public void addTransactionListener(TransactionListener listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.transactionListeners.remove(listener);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        Set<Long> threadIds = this.transactionThreadMap.keySet();
        Iterator<Long> it = threadIds.iterator();
        while (it.hasNext()) {
            long threadId = it.next();
            if (!this.hasThreadTerminated(threadId)) continue;
            it.remove();
        }
    }

    private boolean hasThreadTerminated(long threadId) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(threadId, 0);
        if (threadInfo == null) {
            return true;
        }
        return threadInfo.getThreadState() == Thread.State.TERMINATED;
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

