/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.ExtensionService;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.IgnoreTransactionTracerFactory;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.tracers.RetryException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracerService
extends AbstractService {
    private final Map<String, TracerFactory> tracerFactories = new ConcurrentHashMap<String, TracerFactory>();
    private volatile PointCutInvocationHandler[] invocationHandlers = new PointCutInvocationHandler[0];
    public ITracerService tracerServiceFactory;

    public TracerService() {
        super(TracerService.class.getSimpleName());
        this.registerTracerFactory(IgnoreTransactionTracerFactory.TRACER_FACTORY_NAME, new IgnoreTransactionTracerFactory());
        ExtensionService extensionService = ServiceFactory.getExtensionService();
        for (ConfigurationConstruct construct : PointCutFactory.getConstructs()) {
            extensionService.addConstruct(construct);
        }
        this.tracerServiceFactory = new NoOpTracerService();
    }

    public Tracer getTracer(TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
        if (tracerFactory == null) {
            return null;
        }
        return this.tracerServiceFactory.getTracer(tracerFactory, signature, object, args);
    }

    public TracerFactory getTracerFactory(String tracerFactoryName) {
        return this.tracerFactories.get(tracerFactoryName);
    }

    public void registerTracerFactory(String name, TracerFactory tracerFactory) {
        this.tracerFactories.put(name.intern(), tracerFactory);
    }

    public void registerInvocationHandlers(List<PointCutInvocationHandler> handlers) {
        this.invocationHandlers = handlers.toArray(new PointCutInvocationHandler[handlers.size()]);
    }

    public int getInvocationHandlerId(PointCutInvocationHandler handler) {
        for (int i = 0; i < this.invocationHandlers.length; ++i) {
            if (this.invocationHandlers[i] != handler) continue;
            return i;
        }
        return -1;
    }

    public PointCutInvocationHandler getInvocationHandler(int id) {
        return this.invocationHandlers[id];
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        this.tracerFactories.clear();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private class TracerServiceImpl
    implements ITracerService {
        private TracerServiceImpl() {
        }

        public Tracer getTracer(TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
            Transaction transaction = Transaction.getTransaction();
            if (transaction == null) {
                return null;
            }
            try {
                return transaction.getTransactionState().getTracer(transaction, tracerFactory, signature, object, args);
            }
            catch (RetryException e) {
                return this.getTracer(tracerFactory, signature, object, args);
            }
        }
    }

    private class NoOpTracerService
    implements ITracerService {
        private NoOpTracerService() {
        }

        public Tracer getTracer(TracerFactory tracerFactory, ClassMethodSignature signature, Object object, Object ... args) {
            if (ServiceFactory.getServiceManager().isStarted()) {
                TracerService.this.tracerServiceFactory = new TracerServiceImpl();
                return TracerService.this.tracerServiceFactory.getTracer(tracerFactory, signature, object, args);
            }
            return null;
        }
    }

    private static interface ITracerService {
        public Tracer getTracer(TracerFactory var1, ClassMethodSignature var2, Object var3, Object ... var4);
    }
}

