/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Environment;
import com.newrelic.agent.EnvironmentService;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.lang.management.ManagementFactory;

public class EnvironmentServiceImpl
extends AbstractService
implements EnvironmentService {
    private final int processPID = this.initProcessPID();
    private final Environment environment;

    public EnvironmentServiceImpl() {
        super(EnvironmentService.class.getSimpleName());
        IAgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.environment = this.initEnvironment(config);
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public boolean isEnabled() {
        return true;
    }

    public int getProcessPID() {
        return this.processPID;
    }

    private int initProcessPID() {
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = runtimeName.split("@");
        if (split.length > 1) {
            return Integer.parseInt(split[0]);
        }
        return 0;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    private Environment initEnvironment(IAgentConfig config) {
        String logFilePath = AgentLogManager.getLogFilePath();
        if (logFilePath == null) {
            logFilePath = "";
        }
        return new Environment(config, logFilePath);
    }
}

