/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.CrossProcessTransactionState;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.config.ICrossProcessConfig;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.parser.JSONParser;
import com.newrelic.org.json.simple.parser.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class CrossProcessTransactionStateImpl
implements CrossProcessTransactionState {
    public static final String NEWRELIC_ID_HEADER = "X-NewRelic-ID";
    public static final String X_NEWRELIC_TRANSACTION_HEADER = "X-NewRelic-Transaction";
    public static final String X_NEW_RELIC_APP_DATA_HEADER = "X-NewRelic-App-Data";
    private static final String CONTENT_LENGTH_REQUEST_HEADER = "Content-Length";
    private static final String NEWRELIC_ID_HEADER_SEPARATOR = "#";
    private static final boolean OPTIMISTIC_TRACING = false;
    private final ITransaction tx;
    private boolean crossProccessHeaderDone = false;
    private String clientCrossProcessId;
    private String guid;
    private String referrerGuid;
    private boolean forceTransactionTrace;

    private CrossProcessTransactionStateImpl(ITransaction tx) {
        this.tx = tx;
    }

    private boolean getForceTransactionTrace() {
        return false;
    }

    public String getClientCrossProcessId() {
        return this.clientCrossProcessId;
    }

    private void writeCrossProcessHeader(HttpRequest request, HttpResponse response) {
        this.clientCrossProcessId = this.getTrustedClientCrossProcessId(request);
        if (this.clientCrossProcessId == null) {
            return;
        }
        this.tx.freezeTransactionName();
        if (this.tx.isIgnore()) {
            return;
        }
        String guid = null;
        this.readTransactionHeader(request);
        if (this.referrerGuid != null) {
            guid = this.getOrCreateGuid();
        }
        long contentLength = this.getRequestContentLength(request);
        long durationInNanos = this.tx.getRunningDurationInNanos();
        this.writeCrossProcessAppDataResponseHeader(durationInNanos, contentLength, guid, response);
        this.recordClientApplicationMetric(durationInNanos);
    }

    public void writeResponseHeaders() {
        if (this.crossProccessHeaderDone) {
            return;
        }
        this.crossProccessHeaderDone = true;
        if (this.tx.isIgnore()) {
            return;
        }
        Dispatcher dispatcher = this.tx.getDispatcher();
        if (dispatcher == null) {
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            return;
        }
        HttpRequest request = dispatcher.getRequest();
        if (request == null) {
            return;
        }
        HttpResponse response = dispatcher.getResponse();
        if (response == null) {
            return;
        }
        this.writeCrossProcessHeader(request, response);
    }

    public String getReferrerGuid() {
        return this.referrerGuid;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTransactionHeaderValue() {
        String guid = this.getOrCreateGuid();
        if (guid == null) {
            return null;
        }
        String json = this.getTransactionHeaderJson(guid, this.getForceTransactionTrace());
        String encoded = this.getEncodedJson(json);
        if (Agent.LOG.isFinerEnabled()) {
            String msg = MessageFormat.format("Sending {0} header: {1} obfuscated: {2}", X_NEWRELIC_TRANSACTION_HEADER, json, encoded);
            Agent.LOG.finer(msg);
        }
        return encoded;
    }

    private String getTransactionHeaderJson(String guid, boolean forceTransactionTrace) {
        List<Serializable> args = Arrays.asList(guid, forceTransactionTrace);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            JSONArray.writeJSONString(args, writer);
            ((Writer)writer).close();
            return out.toString();
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error getting JSON: {0}", e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    public String getOrCreateGuid() {
        if (this.guid == null) {
            this.guid = this.tx.getBeaconTransactionState().getGuid();
            if (this.guid == null) {
                this.guid = this.createGuid();
            }
        }
        return this.guid;
    }

    private String createGuid() {
        return ServiceFactory.getTransactionTraceService().generateTransactionGuid();
    }

    private String getTrustedClientCrossProcessId(HttpRequest request) {
        ICrossProcessConfig crossProcessConfig = this.tx.getCrossProcessConfig();
        if (crossProcessConfig.getEncodingKey() == null || crossProcessConfig.getCrossProcessId() == null) {
            return null;
        }
        String clientCrossProcessId = request.getHeader(NEWRELIC_ID_HEADER);
        if (clientCrossProcessId == null || clientCrossProcessId.length() == 0) {
            return null;
        }
        String decoded = this.getDecodedClientCrossProcessId(clientCrossProcessId);
        if (!this.isClientCrossProcessIdTrusted(decoded)) {
            return null;
        }
        return decoded;
    }

    private void readTransactionHeader(HttpRequest request) {
        String encodedJson = request.getHeader(X_NEWRELIC_TRANSACTION_HEADER);
        if (encodedJson == null || encodedJson.length() == 0) {
            return;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        String json = null;
        try {
            json = Obfuscator.deobfuscateNameUsingKey(encodedJson, encodingKey);
        }
        catch (UnsupportedEncodingException ex) {
            String msg = MessageFormat.format("Error decoding {0} header {1}: {2}", X_NEWRELIC_TRANSACTION_HEADER, encodedJson, ex);
            Agent.LOG.error(msg);
        }
        if (json != null) {
            this.parseTransactionHeader(json);
        }
    }

    private void parseTransactionHeader(String header) {
        block2: {
            try {
                JSONParser parser = new JSONParser();
                JSONArray arr = (JSONArray)parser.parse(header);
                this.referrerGuid = (String)arr.get(0);
                this.forceTransactionTrace = (Boolean)arr.get(1);
            }
            catch (ParseException ex) {
                if (!Agent.LOG.isFinerEnabled()) break block2;
                String msg = MessageFormat.format("Unable to parse {0} header {1}: {2}", X_NEWRELIC_TRANSACTION_HEADER, header, ex);
                Agent.LOG.finer(msg);
            }
        }
    }

    private boolean isClientCrossProcessIdTrusted(String clientCrossProcessId) {
        String accountId = this.getAccountId(clientCrossProcessId);
        if (accountId != null) {
            if (this.tx.getCrossProcessConfig().isTrustedAccountId(accountId)) {
                return true;
            }
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Account id {0} in client cross process id {1} is not trusted", accountId, clientCrossProcessId);
                Agent.LOG.log(Level.FINEST, msg);
            }
        } else if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Account id not found in client cross process id {0}", clientCrossProcessId);
            Agent.LOG.log(Level.FINER, msg);
        }
        return false;
    }

    private String getAccountId(String clientCrossProcessId) {
        String accountId = null;
        int index = clientCrossProcessId.indexOf(NEWRELIC_ID_HEADER_SEPARATOR);
        if (index > 0) {
            accountId = clientCrossProcessId.substring(0, index);
        }
        return accountId;
    }

    private String getDecodedClientCrossProcessId(String clientCrossProcessId) {
        if (clientCrossProcessId.length() == 0) {
            return clientCrossProcessId;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        try {
            return Obfuscator.deobfuscateNameUsingKey(clientCrossProcessId, encodingKey);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format("Error decoding cross process id {0}: {1}", clientCrossProcessId, ex);
            Agent.LOG.error(msg);
            return null;
        }
    }

    private void writeCrossProcessAppDataResponseHeader(long durationInNanos, long contentLength, String guid, HttpResponse response) {
        String json = this.getCrossProcessAppDataJson(durationInNanos, contentLength, guid);
        String encodedJson = this.getEncodedJson(json);
        if (encodedJson == null) {
            return;
        }
        response._nr_setHeader(X_NEW_RELIC_APP_DATA_HEADER, encodedJson);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Set {0} response header to: {1}", X_NEW_RELIC_APP_DATA_HEADER, json);
            Agent.LOG.log(Level.FINER, msg);
        }
    }

    private String getCrossProcessAppDataJson(long durationInNanos, long contentLength, String guid) {
        String crossProcessId = this.tx.getCrossProcessConfig().getCrossProcessId();
        String transactionName = this.tx.getPriorityTransactionName().getName();
        Float queueTimeInSeconds = Float.valueOf((float)this.tx.getExternalTime() / 1000.0f);
        Float durationInSeconds = Float.valueOf((float)durationInNanos / 1.0E9f);
        List<Serializable> args = guid == null ? Arrays.asList(crossProcessId, transactionName, queueTimeInSeconds, durationInSeconds, contentLength) : Arrays.asList(crossProcessId, transactionName, queueTimeInSeconds, durationInSeconds, contentLength, guid);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            JSONArray.writeJSONString(args, writer);
            ((Writer)writer).close();
            return out.toString();
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Error getting JSON: {0}", e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    private long getRequestContentLength(HttpRequest request) {
        long contentLength = -1L;
        String contentLengthString = request.getHeader(CONTENT_LENGTH_REQUEST_HEADER);
        if (contentLengthString != null) {
            try {
                contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing {0} response header: {1}: {2}", CONTENT_LENGTH_REQUEST_HEADER, contentLengthString, e);
                Agent.LOG.finer(msg);
            }
        }
        return contentLength;
    }

    private String getEncodedJson(String json) {
        if (json == null) {
            return null;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        try {
            return Obfuscator.obfuscateNameUsingKey(json, encodingKey);
        }
        catch (UnsupportedEncodingException e) {
            String msg = MessageFormat.format("Error encoding {0} response header {1} using key {2}: {3}", X_NEW_RELIC_APP_DATA_HEADER, json, encodingKey, e);
            Agent.LOG.error(msg);
            return null;
        }
    }

    private void recordClientApplicationMetric(long durationInNanos) {
        if (this.clientCrossProcessId == null || this.clientCrossProcessId.length() == 0) {
            return;
        }
        String metricName = MessageFormat.format("ClientApplication/{0}/all", this.clientCrossProcessId);
        this.tx.getTransactionStats().getUnscopedStats().getResponseTimeStats(metricName).recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    public static CrossProcessTransactionStateImpl create(ITransaction tx) {
        return tx == null ? null : new CrossProcessTransactionStateImpl(tx);
    }
}

