/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class LlmFeedbackEventAttributes {
    private final String traceId;
    private final Object rating;
    private final String category;
    private final String message;
    private final Map<String, String> metadata;
    private final UUID id;
    private final String ingestSource;
    private static final String INGEST_SOURCE = "Java";

    protected LlmFeedbackEventAttributes(String traceId, Object rating, String category, String message, Map<String, String> metadata, UUID id, String ingestSource) {
        this.traceId = traceId;
        this.rating = rating;
        this.category = category;
        this.message = message;
        this.metadata = metadata;
        this.id = id;
        this.ingestSource = ingestSource;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Object getRating() {
        return this.rating;
    }

    public String getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public UUID getId() {
        return this.id;
    }

    public String getIngestSource() {
        return this.ingestSource;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> feedbackAttributesMap = new HashMap<String, Object>();
        feedbackAttributesMap.put("trace_id", this.getTraceId());
        feedbackAttributesMap.put("rating", this.getRating());
        feedbackAttributesMap.put("id", this.getId());
        feedbackAttributesMap.put("ingest_source", this.getIngestSource());
        if (this.category != null) {
            feedbackAttributesMap.put("category", this.getCategory());
        }
        if (this.message != null) {
            feedbackAttributesMap.put("message", this.getMessage());
        }
        if (this.metadata != null) {
            feedbackAttributesMap.put("metadata", this.getMetadata());
        }
        return feedbackAttributesMap;
    }

    public static class Builder {
        private final String traceId;
        private final Object rating;
        private String category = null;
        private String message = null;
        private Map<String, String> metadata = null;
        private final UUID id = UUID.randomUUID();

        public Builder(String traceId, Object rating) {
            this.traceId = traceId;
            this.rating = rating;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Map<String, Object> build() {
            return new LlmFeedbackEventAttributes(this.traceId, this.rating, this.category, this.message, this.metadata, this.id, LlmFeedbackEventAttributes.INGEST_SOURCE).toMap();
        }
    }
}

