/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp2;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.okhttp2.PrebufferedResponseBody;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.TreeMap;
import okio.Buffer;
import okio.BufferedSource;

public class OkHttp2TransactionStateUtil
extends TransactionStateUtil {
    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        if (request == null) {
            log.debug("Missing request");
        } else {
            if (!transactionState.isSent()) {
                OkHttp2TransactionStateUtil.inspectAndInstrument(transactionState, request.urlString(), request.method());
            }
            try {
                RequestBody body = request.body();
                if (body != null && body.contentLength() > 0L) {
                    transactionState.setBytesSent(body.contentLength());
                }
            }
            catch (IOException e) {
                log.debug("Could not determine request length: " + e);
            }
        }
    }

    public static Response inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = "";
        int statusCode = -1;
        long contentLength = 0L;
        if (response == null) {
            statusCode = 500;
            log.debug("Missing response");
        } else {
            String url;
            Request request = response.request();
            if (request != null && request.url() != null && !(url = request.url().toString()).isEmpty()) {
                OkHttp2TransactionStateUtil.inspectAndInstrument(transactionState, url, request.method());
            }
            try {
                appData = response.header("X-NewRelic-App-Data");
                statusCode = response.code();
                contentLength = OkHttp2TransactionStateUtil.exhaustiveContentLength(response);
            }
            catch (Exception e) {
                log.debug("OkHttp2TransactionStateUtil: Missing body or content length");
            }
        }
        OkHttp2TransactionStateUtil.inspectAndInstrumentResponse(transactionState, appData, (int)contentLength, statusCode);
        return OkHttp2TransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    protected static Response addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData != null) {
            if (response != null && transactionState.isErrorOrFailure()) {
                String responseBodyString;
                TreeMap<String, String> params;
                block8: {
                    String contentTypeHeader = response.header("Content-Type");
                    params = new TreeMap<String, String>();
                    if (contentTypeHeader != null && !contentTypeHeader.isEmpty()) {
                        params.put("content_type", contentTypeHeader);
                    }
                    params.put("content_length", transactionState.getBytesReceived() + "");
                    responseBodyString = "";
                    try {
                        if (response.body() != null) {
                            ResponseBody body = response.body();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(body.bytes());
                            Buffer buffer = new Buffer().write(byteBuffer.array());
                            PrebufferedResponseBody newBody = new PrebufferedResponseBody(body, (BufferedSource)buffer);
                            response = response.newBuilder().body((ResponseBody)newBody).build();
                            responseBodyString = new String(byteBuffer.array());
                        } else if (response.message() != null) {
                            log.debug("Missing response body, using response message");
                            responseBodyString = response.message();
                        }
                    }
                    catch (Exception e) {
                        if (response.message() == null) break block8;
                        log.debug("Missing response body, using response message");
                        responseBodyString = response.message();
                    }
                }
                transactionData.setResponseBody(responseBodyString);
                transactionData.setParams(params);
                Measurements.addHttpError(transactionData);
                response = OkHttp2TransactionStateUtil.setDistributedTraceHeaders(transactionState, response);
            }
            HttpTransactionMeasurement httpTransactionMeasurement = new HttpTransactionMeasurement(transactionData);
            TaskQueue.queue(httpTransactionMeasurement);
        }
        return response;
    }

    private static long exhaustiveContentLength(Response response) {
        long contentLength = -1L;
        if (response != null) {
            if (response.body() != null) {
                try {
                    contentLength = response.body().contentLength();
                }
                catch (IOException e) {
                    log.debug("Failed to parse content length: " + e.toString());
                }
            }
            if (contentLength < 0L) {
                String responseBodyString = response.header("Content-Length");
                if (responseBodyString != null && responseBodyString.length() > 0) {
                    try {
                        contentLength = Long.parseLong(responseBodyString);
                    }
                    catch (NumberFormatException e) {
                        log.debug("Failed to parse content length: " + e.toString());
                    }
                } else {
                    Response networkResponse = response.networkResponse();
                    if (networkResponse != null) {
                        responseBodyString = networkResponse.header("Content-Length");
                        if (responseBodyString != null && responseBodyString.length() > 0) {
                            try {
                                contentLength = Long.parseLong(responseBodyString);
                            }
                            catch (NumberFormatException e) {
                                log.debug("Failed to parse content length: " + e.toString());
                            }
                        } else if (networkResponse.body() != null) {
                            try {
                                contentLength = networkResponse.body().contentLength();
                            }
                            catch (IOException e) {
                                log.debug("Failed to parse network response content length: " + e.toString());
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return contentLength;
    }

    public static Request setDistributedTraceHeaders(TransactionState transactionState, Request request) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            try {
                Request.Builder builder = request.newBuilder();
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        builder = builder.header(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                }
                TraceContext.reportSupportabilityMetrics();
                return builder.build();
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
        return request;
    }

    public static Response setDistributedTraceHeaders(TransactionState transactionState, Response response) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            try {
                Response.Builder builder = response.newBuilder();
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        builder = builder.header(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                }
                TraceContext.reportSupportabilityMetrics();
                return builder.build();
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
        return response;
    }
}

