/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.walk.AbstractWalkHandler;
import com.networknt.schema.walk.WalkEvent;
import com.networknt.schema.walk.WalkListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import tools.jackson.databind.JsonNode;

public class KeywordWalkHandler
extends AbstractWalkHandler {
    private final List<WalkListener> allKeywordWalkListeners;
    private final Map<String, List<WalkListener>> keywordWalkListenersMap;

    public KeywordWalkHandler(List<WalkListener> allKeywordWalkListeners, Map<String, List<WalkListener>> keywordWalkListenersMap) {
        this.allKeywordWalkListeners = allKeywordWalkListeners;
        this.keywordWalkListenersMap = keywordWalkListenersMap;
    }

    @Override
    public boolean preWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator) {
        boolean continueRunningListenersAndWalk = true;
        WalkEvent keywordWalkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        List<WalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        continueRunningListenersAndWalk = this.runPreWalkListeners(currentKeywordListeners, keywordWalkEvent);
        if (continueRunningListenersAndWalk) {
            this.runPreWalkListeners(this.allKeywordWalkListeners, keywordWalkEvent);
        }
        return continueRunningListenersAndWalk;
    }

    @Override
    public void postWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator, List<Error> errors) {
        WalkEvent keywordWalkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        List<WalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        this.runPostWalkListeners(currentKeywordListeners, keywordWalkEvent, errors);
        this.runPostWalkListeners(this.allKeywordWalkListeners, keywordWalkEvent, errors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, List<WalkListener>> keywordWalkListeners = new HashMap<String, List<WalkListener>>();
        private List<WalkListener> allKeywordWalkListeners = new ArrayList<WalkListener>();

        public Builder keywordWalkListener(String keyword, WalkListener keywordWalkListener) {
            this.keywordWalkListeners.computeIfAbsent(keyword, key -> new ArrayList()).add(keywordWalkListener);
            return this;
        }

        public Builder keywordWalkListener(Keyword keyword, WalkListener keywordWalkListener) {
            return this.keywordWalkListener(keyword.getValue(), keywordWalkListener);
        }

        public Builder keywordWalkListener(WalkListener keywordWalkListener) {
            this.allKeywordWalkListeners.add(keywordWalkListener);
            return this;
        }

        public Builder keywordWalkListeners(Consumer<Map<String, List<WalkListener>>> keywordWalkListeners) {
            keywordWalkListeners.accept(this.keywordWalkListeners);
            return this;
        }

        public KeywordWalkHandler build() {
            return new KeywordWalkHandler(this.allKeywordWalkListeners, this.keywordWalkListeners);
        }
    }
}

