/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.walk.AbstractWalkHandler;
import com.networknt.schema.walk.WalkEvent;
import com.networknt.schema.walk.WalkListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import tools.jackson.databind.JsonNode;

public class ItemWalkHandler
extends AbstractWalkHandler {
    private final List<WalkListener> itemWalkListeners;

    public ItemWalkHandler(List<WalkListener> itemWalkListeners) {
        this.itemWalkListeners = itemWalkListeners;
    }

    @Override
    public boolean preWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator) {
        WalkEvent walkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        return this.runPreWalkListeners(this.itemWalkListeners, walkEvent);
    }

    @Override
    public void postWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator, List<Error> errors) {
        WalkEvent walkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        this.runPostWalkListeners(this.itemWalkListeners, walkEvent, errors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<WalkListener> itemWalkListeners = new ArrayList<WalkListener>();

        public Builder itemWalkListener(WalkListener itemWalkListener) {
            this.itemWalkListeners.add(itemWalkListener);
            return this;
        }

        public Builder itemWalkListeners(Consumer<List<WalkListener>> itemWalkListeners) {
            itemWalkListeners.accept(this.itemWalkListeners);
            return this;
        }

        public ItemWalkHandler build() {
            return new ItemWalkHandler(this.itemWalkListeners);
        }
    }
}

