/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaRegistryConfig;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.Strings;
import com.networknt.schema.utils.TypeFactory;
import tools.jackson.databind.JsonNode;

public class JsonNodeTypes {
    private static final long V6_VALUE = SpecificationVersion.DRAFT_6.getOrder();
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final String NULLABLE = "nullable";

    public static boolean isNodeNullable(JsonNode schema) {
        JsonNode nullable = schema.get(NULLABLE);
        return nullable != null && nullable.asBoolean();
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonType schemaType, Schema parentSchema, SchemaContext schemaContext, ExecutionContext executionContext) {
        SchemaRegistryConfig config = schemaContext.getSchemaRegistryConfig();
        JsonType nodeType = TypeFactory.getValueNodeType(node, config);
        if (nodeType != schemaType) {
            Schema grandParentSchema;
            if (schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            if (schemaType == JsonType.INTEGER && nodeType == JsonType.NUMBER && node.canConvertToExactIntegral() && V6_VALUE <= JsonNodeTypes.detectVersion(schemaContext)) {
                return true;
            }
            if (nodeType == JsonType.NULL && parentSchema != null && schemaContext.isNullableKeywordEnabled() && ((grandParentSchema = parentSchema.getParentSchema()) != null && JsonNodeTypes.isNodeNullable(grandParentSchema.getSchemaNode()) || JsonNodeTypes.isNodeNullable(parentSchema.getSchemaNode()))) {
                return true;
            }
            if (!config.isStrict(TYPE, Boolean.TRUE) && JsonNodeTypes.isEnumObjectSchema(parentSchema, executionContext)) {
                return true;
            }
            if (config != null && config.isTypeLoose()) {
                if (schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING) {
                    if (schemaType == JsonType.INTEGER) {
                        return Strings.isInteger(node.asString());
                    }
                    if (schemaType == JsonType.BOOLEAN) {
                        return Strings.isBoolean(node.asString());
                    }
                    if (schemaType == JsonType.NUMBER) {
                        return Strings.isNumeric(node.asString());
                    }
                }
            }
            return schemaType == JsonType.ANY;
        }
        return true;
    }

    private static long detectVersion(SchemaContext schemaContext) {
        return schemaContext.getDialect().getSpecificationVersion().getOrder();
    }

    public static boolean isNumber(JsonNode node, SchemaRegistryConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return Strings.isNumeric(node.asString());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(Schema jsonSchema, ExecutionContext executionContext) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        boolean refNode = false;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            refNode = REF.equals(executionContext.getEvaluationPath().getParent().getElement(-1));
        }
        if (typeNode != null && enumNode != null && refNode) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

