/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.serialization;

import com.networknt.schema.InputFormat;
import com.networknt.schema.serialization.JsonMapperFactory;
import com.networknt.schema.serialization.NodeReader;
import com.networknt.schema.serialization.YamlMapperFactory;
import java.io.IOException;
import java.io.InputStream;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;

public class BasicNodeReader
implements NodeReader {
    public static BasicNodeReader getInstance() {
        return Holder.INSTANCE;
    }

    protected BasicNodeReader() {
    }

    @Override
    public JsonNode readTree(String content, InputFormat inputFormat) throws IOException {
        return this.getObjectMapper(inputFormat).readTree(content);
    }

    @Override
    public JsonNode readTree(InputStream content, InputFormat inputFormat) throws IOException {
        return this.getObjectMapper(inputFormat).readTree(content);
    }

    protected ObjectMapper getObjectMapper(InputFormat inputFormat) {
        if (InputFormat.JSON.equals((Object)inputFormat)) {
            return JsonMapperFactory.getInstance();
        }
        if (InputFormat.YAML.equals((Object)inputFormat)) {
            return YamlMapperFactory.getInstance();
        }
        throw new IllegalArgumentException("Unsupported input format " + String.valueOf((Object)inputFormat));
    }

    private static class Holder {
        private static final BasicNodeReader INSTANCE = new BasicNodeReader();

        private Holder() {
        }
    }
}

