/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.Iterator;
import tools.jackson.databind.JsonNode;

public class RecursiveRefValidator
extends BaseKeywordValidator {
    public RecursiveRefValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.RECURSIVE_REF, schemaNode, schemaLocation, parentSchema, schemaContext);
        String refValue = schemaNode.asString(schemaNode.toString());
        if (!"#".equals(refValue)) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.RECURSIVE_REF.getValue())).messageKey("internal.invalidRecursiveRef")).message("The value of a $recursiveRef must be '#' but is '{0}'")).instanceLocation(schemaLocation.getFragment())).instanceNode(this.schemaNode)).arguments(refValue)).build();
            throw new SchemaException(error);
        }
    }

    static Schema getSchema(Schema parentSchema, ExecutionContext executionContext) {
        Schema refSchema;
        Schema current = refSchema = parentSchema.findSchemaResourceRoot();
        Schema check = null;
        String base = null;
        String baseCheck = null;
        if (refSchema != null) {
            String string = base = current.getSchemaLocation().getAbsoluteIri() != null ? current.getSchemaLocation().getAbsoluteIri().toString() : "";
            if (current.isRecursiveAnchor()) {
                Iterator<Schema> iter = executionContext.getEvaluationSchema().descendingIterator();
                while (iter.hasNext()) {
                    current = iter.next();
                    baseCheck = current.getSchemaLocation().getAbsoluteIri() != null ? current.getSchemaLocation().getAbsoluteIri().toString() : "";
                    if (base.equals(baseCheck)) continue;
                    base = baseCheck;
                    check = current.findSchemaResourceRoot();
                    if (!check.isRecursiveAnchor()) continue;
                    refSchema = check;
                }
            }
        }
        return refSchema;
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        Schema refSchema = this.getSchemaRef(executionContext).getSchema();
        if (refSchema == null) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.RECURSIVE_REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).arguments(this.schemaNode.toString())).build();
            throw new InvalidSchemaRefException(error);
        }
        refSchema.validate(executionContext, node, rootNode, instanceLocation);
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        Schema refSchema = this.getSchemaRef(executionContext).getSchema();
        if (refSchema == null) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.RECURSIVE_REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).arguments(this.schemaNode.toString())).build();
            throw new InvalidSchemaRefException(error);
        }
        if (node == null) {
            boolean circularDependency = false;
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            Iterator<Schema> iter = executionContext.getEvaluationSchema().descendingIterator();
            while (iter.hasNext()) {
                Schema check = iter.next();
                if (!check.getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return;
            }
        }
        refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    public SchemaRef getSchemaRef(ExecutionContext executionContext) {
        return new SchemaRef(() -> RecursiveRefValidator.getSchema(this.parentSchema, executionContext));
    }
}

