/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.DiscriminatorState;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class DiscriminatorValidator
extends BaseKeywordValidator {
    private final String propertyName;
    private final Map<String, String> mapping;
    private final String defaultMapping;

    public DiscriminatorValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.DISCRIMINATOR, schemaNode, schemaLocation, parentSchema, schemaContext);
        ObjectNode discriminator;
        ObjectNode objectNode = discriminator = schemaNode.isObject() ? (ObjectNode)schemaNode : null;
        if (discriminator != null) {
            JsonNode defaultMapping;
            ObjectNode mapping;
            JsonNode propertyName = discriminator.get("propertyName");
            this.propertyName = propertyName != null ? propertyName.asString() : "";
            JsonNode mappingNode = discriminator.get("mapping");
            ObjectNode objectNode2 = mapping = mappingNode != null && mappingNode.isObject() ? (ObjectNode)mappingNode : null;
            if (mapping != null) {
                this.mapping = new HashMap<String, String>();
                for (Map.Entry entry : mapping.properties()) {
                    this.mapping.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
                }
            } else {
                this.mapping = Collections.emptyMap();
            }
            this.defaultMapping = (defaultMapping = discriminator.get("defaultMapping")) != null ? defaultMapping.asString() : null;
        } else {
            this.propertyName = "";
            this.mapping = Collections.emptyMap();
            this.defaultMapping = null;
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        DiscriminatorState state = null;
        DiscriminatorState existing = executionContext.getDiscriminatorMapping().get(instanceLocation);
        if (existing != null) {
            if (this.schemaContext.getSchemaRegistryConfig().isStrict("discriminator", Boolean.FALSE)) {
                throw new SchemaException("Schema at " + String.valueOf(this.schemaLocation) + " has a discriminator keyword for which another discriminator keyword has already been set for at " + String.valueOf(instanceLocation));
            }
            if (!"".equals(this.propertyName) && !existing.getPropertyName().equals(this.propertyName)) {
                throw new SchemaException("Schema at " + String.valueOf(this.schemaLocation) + " is redefining the discriminator property that has already been set for at " + String.valueOf(instanceLocation));
            }
            state = existing;
        } else {
            state = new DiscriminatorState();
            state.setPropertyName(this.propertyName);
            executionContext.getDiscriminatorMapping().put(instanceLocation, state);
        }
        JsonNode discriminatingValueNode = node.get(state.getPropertyName());
        if (discriminatingValueNode != null && discriminatingValueNode.isString()) {
            String discriminatingValue = discriminatingValueNode.asString();
            state.setDiscriminatingValue(discriminatingValue);
            String mappedSchema = this.mapping.get(discriminatingValue);
            if (existing != null && mappedSchema != null && existing.isExplicitMapping() && !existing.getMappedSchema().equals(mappedSchema)) {
                throw new SchemaException("Schema at " + String.valueOf(this.schemaLocation) + " is mapping that has already been set for " + String.valueOf(instanceLocation) + " from " + existing.getMappedSchema() + " to " + mappedSchema);
            }
            if (mappedSchema != null) {
                state.setMappedSchema(mappedSchema);
                state.setExplicitMapping(true);
            } else if (!state.isExplicitMapping()) {
                state.setMappedSchema(discriminatingValue);
                state.setExplicitMapping(false);
            }
        } else {
            if (this.defaultMapping != null) {
                state.setMappedSchema(this.defaultMapping);
                state.setExplicitMapping(true);
                return;
            }
            if (this.schemaContext.getSchemaRegistryConfig().isStrict("discriminator", Boolean.FALSE)) {
                executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).messageKey("discriminator.missing_discriminating_value")).arguments(this.propertyName)).build());
            }
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }
}

