/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;

public class AllOfValidator
extends BaseKeywordValidator {
    private final List<Schema> schemas;

    public AllOfValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.ALL_OF, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.schemaContext.getSchemaRegistryConfig());
            throw new SchemaException(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size = schemaNode.size();
        this.schemas = new ArrayList<Schema>(size);
        for (int i = 0; i < size; ++i) {
            this.schemas.add(schemaContext.newSchema(schemaLocation.append(i), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        int schemaIndex = 0;
        for (Schema schema : this.schemas) {
            executionContext.evaluationPathAddLast(schemaIndex);
            try {
                if (!walk) {
                    schema.validate(executionContext, node, rootNode, instanceLocation);
                } else {
                    schema.walk(executionContext, node, rootNode, instanceLocation, true);
                }
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
            ++schemaIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node != null) {
            this.validate(executionContext, node, rootNode, instanceLocation, true);
            return;
        }
        int schemaIndex = 0;
        for (Schema schema : this.schemas) {
            executionContext.evaluationPathAddLast(schemaIndex);
            try {
                schema.walk(executionContext, node, rootNode, instanceLocation, false);
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
            ++schemaIndex;
        }
    }

    @Override
    public void preloadSchema() {
        this.preloadSchemas(this.schemas);
    }
}

