/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.i18n.MessageFormatter;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.CachingSupplier;
import com.networknt.schema.utils.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.ser.std.ToStringSerializer;

@JsonIgnoreProperties(value={"messageSupplier", "schemaNode", "instanceNode"})
@JsonPropertyOrder(value={"keyword", "instanceLocation", "message", "evaluationPath", "schemaLocation", "messageKey", "arguments", "details"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Error {
    private final String keyword;
    @JsonSerialize(using=ToStringSerializer.class)
    private final NodePath evaluationPath;
    @JsonSerialize(using=ToStringSerializer.class)
    private final SchemaLocation schemaLocation;
    @JsonSerialize(using=ToStringSerializer.class)
    private final NodePath instanceLocation;
    private final Object[] arguments;
    private final String messageKey;
    private final Supplier<String> messageSupplier;
    private final Map<String, Object> details;
    private final JsonNode instanceNode;
    private final JsonNode schemaNode;

    Error(String keyword, NodePath evaluationPath, SchemaLocation schemaLocation, NodePath instanceLocation, Object[] arguments, Map<String, Object> details, String messageKey, Supplier<String> messageSupplier, JsonNode instanceNode, JsonNode schemaNode) {
        this.keyword = keyword;
        this.instanceLocation = instanceLocation;
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.arguments = arguments;
        this.details = details;
        this.messageKey = messageKey;
        this.messageSupplier = messageSupplier;
        this.instanceNode = instanceNode;
        this.schemaNode = schemaNode;
    }

    public NodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public NodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public JsonNode getInstanceNode() {
        return this.instanceNode;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public String getProperty() {
        if (this.details == null) {
            return null;
        }
        return (String)this.getDetails().get("property");
    }

    public Integer getIndex() {
        if (this.details == null) {
            return null;
        }
        return (Integer)this.getDetails().get("index");
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public String getMessage() {
        return this.messageSupplier.get();
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.instanceLocation != null) {
            builder.append(this.instanceLocation.toString());
        } else if (this.schemaLocation != null) {
            builder.append(this.schemaLocation.toString());
        }
        builder.append(": ");
        builder.append(this.messageSupplier.get());
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error that = (Error)o;
        if (this.keyword != null ? !this.keyword.equals(that.keyword) : that.keyword != null) {
            return false;
        }
        if (this.instanceLocation != null ? !this.instanceLocation.equals(that.instanceLocation) : that.instanceLocation != null) {
            return false;
        }
        if (this.evaluationPath != null ? !this.evaluationPath.equals(that.evaluationPath) : that.evaluationPath != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.messageKey != null ? !this.messageKey.equals(that.messageKey) : that.messageKey != null) {
            return false;
        }
        return Arrays.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = this.keyword != null ? this.keyword.hashCode() : 0;
        result = 31 * result + (this.instanceLocation != null ? this.instanceLocation.hashCode() : 0);
        result = 31 * result + (this.evaluationPath != null ? this.evaluationPath.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
        result = 31 * result + (this.messageKey != null ? this.messageKey.hashCode() : 0);
        return result;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        @Override
        public Builder self() {
            return this;
        }
    }

    public static abstract class BuilderSupport<S> {
        protected String keyword;
        protected NodePath evaluationPath;
        protected SchemaLocation schemaLocation;
        protected NodePath instanceLocation;
        protected Object[] arguments;
        protected Map<String, Object> details;
        protected MessageFormat format;
        protected String message;
        protected Supplier<String> messageSupplier;
        protected MessageFormatter messageFormatter;
        protected String messageKey;
        protected JsonNode instanceNode;
        protected JsonNode schemaNode;

        public abstract S self();

        public S keyword(String keyword) {
            this.keyword = keyword;
            return this.self();
        }

        public S property(String properties) {
            if (this.details == null) {
                this.details = new HashMap<String, Object>();
            }
            this.details.put("property", properties);
            return this.self();
        }

        public S index(Integer index) {
            if (this.details == null) {
                this.details = new HashMap<String, Object>();
            }
            this.details.put("index", index);
            return this.self();
        }

        public S instanceLocation(NodePath instanceLocation) {
            this.instanceLocation = instanceLocation;
            return this.self();
        }

        public S schemaLocation(SchemaLocation schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this.self();
        }

        public S evaluationPath(NodePath evaluationPath) {
            this.evaluationPath = evaluationPath;
            return this.self();
        }

        public S arguments(Object ... arguments) {
            this.arguments = arguments;
            return this.self();
        }

        public S details(Map<String, Object> details) {
            this.details = details;
            return this.self();
        }

        public S format(MessageFormat format) {
            this.format = format;
            return this.self();
        }

        public S message(String message) {
            this.message = message;
            return this.self();
        }

        public S messageSupplier(Supplier<String> messageSupplier) {
            this.messageSupplier = messageSupplier;
            return this.self();
        }

        public S messageFormatter(MessageFormatter messageFormatter) {
            this.messageFormatter = messageFormatter;
            return this.self();
        }

        public S messageKey(String messageKey) {
            this.messageKey = messageKey;
            return this.self();
        }

        public S instanceNode(JsonNode instanceNode) {
            this.instanceNode = instanceNode;
            return this.self();
        }

        public S schemaNode(JsonNode schemaNode) {
            this.schemaNode = schemaNode;
            return this.self();
        }

        public Error build() {
            Supplier<String> messageSupplier = this.messageSupplier;
            String messageKey = this.messageKey;
            if (!Strings.isBlank(this.message)) {
                messageKey = this.message;
                messageSupplier = this.message.contains("{") ? new CachingSupplier<String>(() -> {
                    MessageFormat format = new MessageFormat(this.message);
                    return format.format(this.getMessageArguments());
                }) : this.message::toString;
            } else if (messageSupplier == null) {
                messageSupplier = new CachingSupplier<String>(() -> {
                    MessageFormatter formatter = this.messageFormatter != null ? this.messageFormatter : this.format::format;
                    return formatter.format(this.getMessageArguments());
                });
            }
            return new Error(this.keyword, this.evaluationPath, this.schemaLocation, this.instanceLocation, this.arguments, this.details, messageKey, messageSupplier, this.instanceNode, this.schemaNode);
        }

        protected Object[] getMessageArguments() {
            return this.arguments;
        }

        protected String getKeyword() {
            return this.keyword;
        }

        protected NodePath getEvaluationPath() {
            return this.evaluationPath;
        }

        protected SchemaLocation getSchemaLocation() {
            return this.schemaLocation;
        }

        protected NodePath getInstanceLocation() {
            return this.instanceLocation;
        }

        protected Object[] getArguments() {
            return this.arguments;
        }

        protected Map<String, Object> getDetails() {
            return this.details;
        }

        protected MessageFormat getFormat() {
            return this.format;
        }

        protected String getMessage() {
            return this.message;
        }

        protected Supplier<String> getMessageSupplier() {
            return this.messageSupplier;
        }

        protected MessageFormatter getMessageFormatter() {
            return this.messageFormatter;
        }

        protected String getMessageKey() {
            return this.messageKey;
        }
    }
}

