/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class Vocabulary {
    public static final Vocabulary V201909_CORE = new Vocabulary("https://json-schema.org/draft/2019-09/vocab/core", "$id", "$schema", "$anchor", "$ref", "$recursiveRef", "$recursiveAnchor", "$vocabulary", "$comment", "$defs");
    public static final Vocabulary V201909_APPLICATOR = new Vocabulary("https://json-schema.org/draft/2019-09/vocab/applicator", "additionalItems", "unevaluatedItems", "items", "contains", "additionalProperties", "unevaluatedProperties", "properties", "patternProperties", "dependentSchemas", "propertyNames", "if", "then", "else", "allOf", "anyOf", "oneOf", "not");
    public static final Vocabulary V201909_VALIDATION = new Vocabulary("https://json-schema.org/draft/2019-09/vocab/validation", "multipleOf", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxContains", "minContains", "maxProperties", "minProperties", "required", "dependentRequired", "const", "enum", "type");
    public static final Vocabulary V201909_META_DATA = new Vocabulary("https://json-schema.org/draft/2019-09/vocab/meta-data", "title", "description", "default", "deprecated", "readOnly", "writeOnly", "examples");
    public static final Vocabulary V201909_FORMAT = new Vocabulary("https://json-schema.org/draft/2019-09/vocab/format", "format");
    public static final Vocabulary V201909_CONTENT = new Vocabulary("https://json-schema.org/draft/2019-09/vocab/content", "contentMediaType", "contentEncoding", "contentSchema");
    public static final Vocabulary V202012_CORE = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/core", "$id", "$schema", "$ref", "$anchor", "$dynamicRef", "$dynamicAnchor", "$vocabulary", "$comment", "$defs");
    public static final Vocabulary V202012_APPLICATOR = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/applicator", "prefixItems", "items", "contains", "additionalProperties", "properties", "patternProperties", "dependentSchemas", "propertyNames", "if", "then", "else", "allOf", "anyOf", "oneOf", "not");
    public static final Vocabulary V202012_UNEVALUATED = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/unevaluated", "unevaluatedItems", "unevaluatedProperties");
    public static final Vocabulary V202012_VALIDATION = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/validation", "type", "const", "enum", "multipleOf", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxContains", "minContains", "maxProperties", "minProperties", "required", "dependentRequired");
    public static final Vocabulary V202012_META_DATA = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/meta-data", "title", "description", "default", "deprecated", "readOnly", "writeOnly", "examples");
    public static final Vocabulary V202012_FORMAT_ANNOTATION = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/format-annotation", "format");
    public static final Vocabulary V202012_FORMAT_ASSERTION = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/format-assertion", "format");
    public static final Vocabulary V202012_CONTENT = new Vocabulary("https://json-schema.org/draft/2020-12/vocab/content", "contentEncoding", "contentMediaType", "contentSchema");
    private final String id;
    private final Set<String> keywords;

    public Vocabulary(String id, String ... keywords) {
        this.id = id;
        this.keywords = new LinkedHashSet<String>();
        for (String keyword : keywords) {
            this.keywords.add(keyword);
        }
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.keywords);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vocabulary other = (Vocabulary)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.keywords, other.keywords);
    }

    public String toString() {
        return "Vocabulary [id=" + this.id + ", keywords=" + this.keywords + "]";
    }
}

