/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.AdditionalPropertiesValidator;
import com.networknt.schema.AllOfValidator;
import com.networknt.schema.AnyOfValidator;
import com.networknt.schema.ConstValidator;
import com.networknt.schema.ContainsValidator;
import com.networknt.schema.ContentEncodingValidator;
import com.networknt.schema.ContentMediaTypeValidator;
import com.networknt.schema.DependenciesValidator;
import com.networknt.schema.DependentRequired;
import com.networknt.schema.DependentSchemas;
import com.networknt.schema.DiscriminatorValidator;
import com.networknt.schema.DynamicRefValidator;
import com.networknt.schema.EnumValidator;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.ExclusiveMaximumValidator;
import com.networknt.schema.ExclusiveMinimumValidator;
import com.networknt.schema.FalseValidator;
import com.networknt.schema.IfValidator;
import com.networknt.schema.ItemsValidator;
import com.networknt.schema.ItemsValidator202012;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.MaxItemsValidator;
import com.networknt.schema.MaxLengthValidator;
import com.networknt.schema.MaxPropertiesValidator;
import com.networknt.schema.MaximumValidator;
import com.networknt.schema.MinItemsValidator;
import com.networknt.schema.MinLengthValidator;
import com.networknt.schema.MinMaxContainsValidator;
import com.networknt.schema.MinPropertiesValidator;
import com.networknt.schema.MinimumValidator;
import com.networknt.schema.MultipleOfValidator;
import com.networknt.schema.NotAllowedValidator;
import com.networknt.schema.NotValidator;
import com.networknt.schema.OneOfValidator;
import com.networknt.schema.PatternPropertiesValidator;
import com.networknt.schema.PatternValidator;
import com.networknt.schema.PrefixItemsValidator;
import com.networknt.schema.PropertiesValidator;
import com.networknt.schema.PropertyNamesValidator;
import com.networknt.schema.ReadOnlyValidator;
import com.networknt.schema.RecursiveRefValidator;
import com.networknt.schema.RefValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.TrueValidator;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.UnevaluatedItemsValidator;
import com.networknt.schema.UnevaluatedPropertiesValidator;
import com.networknt.schema.UnionTypeValidator;
import com.networknt.schema.UniqueItemsValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidatorFactory;
import com.networknt.schema.VersionCode;
import com.networknt.schema.WriteOnlyValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ValidatorTypeCode implements Keyword,
ErrorMessageType
{
    ADDITIONAL_PROPERTIES("additionalProperties", "1001", AdditionalPropertiesValidator::new, VersionCode.AllVersions),
    ALL_OF("allOf", "1002", AllOfValidator::new, VersionCode.AllVersions),
    ANY_OF("anyOf", "1003", AnyOfValidator::new, VersionCode.AllVersions),
    CONST("const", "1042", ConstValidator::new, VersionCode.MinV6),
    CONTAINS("contains", "1043", ContainsValidator::new, VersionCode.MinV6),
    CONTENT_ENCODING("contentEncoding", "1052", ContentEncodingValidator::new, VersionCode.V7),
    CONTENT_MEDIA_TYPE("contentMediaType", "1053", ContentMediaTypeValidator::new, VersionCode.V7),
    DEPENDENCIES("dependencies", "1007", DependenciesValidator::new, VersionCode.AllVersions),
    DEPENDENT_REQUIRED("dependentRequired", "1045", DependentRequired::new, VersionCode.MinV201909),
    DEPENDENT_SCHEMAS("dependentSchemas", "1046", DependentSchemas::new, VersionCode.MinV201909),
    DISCRIMINATOR("discriminator", "2001", DiscriminatorValidator::new, VersionCode.None),
    DYNAMIC_REF("$dynamicRef", "1051", DynamicRefValidator::new, VersionCode.MinV202012),
    ENUM("enum", "1008", EnumValidator::new, VersionCode.AllVersions),
    EXCLUSIVE_MAXIMUM("exclusiveMaximum", "1038", ExclusiveMaximumValidator::new, VersionCode.MinV6),
    EXCLUSIVE_MINIMUM("exclusiveMinimum", "1039", ExclusiveMinimumValidator::new, VersionCode.MinV6),
    FALSE("false", "1041", FalseValidator::new, VersionCode.MinV6),
    FORMAT("format", "1009", null, VersionCode.AllVersions){

        @Override
        public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
            throw new UnsupportedOperationException("Use FormatKeyword instead");
        }
    }
    ,
    ID("id", "1036", null, VersionCode.AllVersions),
    IF_THEN_ELSE("if", "1037", IfValidator::new, VersionCode.MinV7),
    ITEMS_202012("items", "1010", ItemsValidator202012::new, VersionCode.MinV202012),
    ITEMS("items", "1010", ItemsValidator::new, VersionCode.MaxV201909),
    MAX_CONTAINS("maxContains", "1006", MinMaxContainsValidator::new, VersionCode.MinV201909),
    MAX_ITEMS("maxItems", "1012", MaxItemsValidator::new, VersionCode.AllVersions),
    MAX_LENGTH("maxLength", "1013", MaxLengthValidator::new, VersionCode.AllVersions),
    MAX_PROPERTIES("maxProperties", "1014", MaxPropertiesValidator::new, VersionCode.AllVersions),
    MAXIMUM("maximum", "1011", MaximumValidator::new, VersionCode.AllVersions),
    MIN_CONTAINS("minContains", "1049", MinMaxContainsValidator::new, VersionCode.MinV201909),
    MIN_ITEMS("minItems", "1016", MinItemsValidator::new, VersionCode.AllVersions),
    MIN_LENGTH("minLength", "1017", MinLengthValidator::new, VersionCode.AllVersions),
    MIN_PROPERTIES("minProperties", "1018", MinPropertiesValidator::new, VersionCode.AllVersions),
    MINIMUM("minimum", "1015", MinimumValidator::new, VersionCode.AllVersions),
    MULTIPLE_OF("multipleOf", "1019", MultipleOfValidator::new, VersionCode.AllVersions),
    NOT_ALLOWED("notAllowed", "1033", NotAllowedValidator::new, VersionCode.AllVersions),
    NOT("not", "1020", NotValidator::new, VersionCode.AllVersions),
    ONE_OF("oneOf", "1022", OneOfValidator::new, VersionCode.AllVersions),
    PATTERN_PROPERTIES("patternProperties", "1024", PatternPropertiesValidator::new, VersionCode.AllVersions),
    PATTERN("pattern", "1023", PatternValidator::new, VersionCode.AllVersions),
    PREFIX_ITEMS("prefixItems", "1048", PrefixItemsValidator::new, VersionCode.MinV202012),
    PROPERTIES("properties", "1025", PropertiesValidator::new, VersionCode.AllVersions),
    PROPERTYNAMES("propertyNames", "1044", PropertyNamesValidator::new, VersionCode.MinV6),
    READ_ONLY("readOnly", "1032", ReadOnlyValidator::new, VersionCode.MinV7),
    RECURSIVE_REF("$recursiveRef", "1050", RecursiveRefValidator::new, VersionCode.V201909),
    REF("$ref", "1026", RefValidator::new, VersionCode.AllVersions),
    REQUIRED("required", "1028", RequiredValidator::new, VersionCode.AllVersions),
    TRUE("true", "1040", TrueValidator::new, VersionCode.MinV6),
    TYPE("type", "1029", TypeValidator::new, VersionCode.AllVersions),
    UNEVALUATED_ITEMS("unevaluatedItems", "1021", UnevaluatedItemsValidator::new, VersionCode.MinV201909),
    UNEVALUATED_PROPERTIES("unevaluatedProperties", "1047", UnevaluatedPropertiesValidator::new, VersionCode.MinV201909),
    UNION_TYPE("unionType", "1030", UnionTypeValidator::new, VersionCode.AllVersions),
    UNIQUE_ITEMS("uniqueItems", "1031", UniqueItemsValidator::new, VersionCode.AllVersions),
    WRITE_ONLY("writeOnly", "1027", WriteOnlyValidator::new, VersionCode.MinV7);

    private static final Map<String, ValidatorTypeCode> CONSTANTS;
    private final String value;
    private final String errorCode;
    private final ValidatorFactory validatorFactory;
    private final VersionCode versionCode;

    private ValidatorTypeCode(String value, String errorCode, ValidatorFactory validatorFactory, VersionCode versionCode) {
        this.value = value;
        this.errorCode = errorCode;
        this.validatorFactory = validatorFactory;
        this.versionCode = versionCode;
    }

    public static List<ValidatorTypeCode> getNonFormatKeywords(SpecVersion.VersionFlag versionFlag) {
        ArrayList<ValidatorTypeCode> result = new ArrayList<ValidatorTypeCode>();
        for (ValidatorTypeCode keyword : ValidatorTypeCode.values()) {
            if (FORMAT.equals(keyword) || !keyword.getVersionCode().getVersions().contains((Object)versionFlag)) continue;
            result.add(keyword);
        }
        return result;
    }

    public static ValidatorTypeCode fromValue(String value) {
        ValidatorTypeCode constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    @Override
    public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        if (this.validatorFactory == null) {
            throw new UnsupportedOperationException("No suitable validator for " + this.getValue());
        }
        return this.validatorFactory.newInstance(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    public VersionCode getVersionCode() {
        return this.versionCode;
    }

    @Override
    public String getErrorCodeValue() {
        return this.getValue();
    }

    static {
        CONSTANTS = new HashMap<String, ValidatorTypeCode>();
        for (ValidatorTypeCode c : ValidatorTypeCode.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

