/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.VersionCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnevaluatedItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedItemsValidator.class);
    private final JsonSchema schema;
    private final boolean isMinV202012;
    private static final SpecVersion.VersionFlag DEFAULT_VERSION = SpecVersion.VersionFlag.V201909;

    public UnevaluatedItemsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_ITEMS, validationContext);
        this.isMinV202012 = VersionCode.MinV202012.getVersions().contains((Object)SpecVersionDetector.detectOptionalVersion(validationContext.getMetaSchema().getUri()).orElse(DEFAULT_VERSION));
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedItems' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (!node.isArray()) {
            return Collections.emptySet();
        }
        UnevaluatedItemsValidator.debug(logger, node, rootNode, instanceLocation);
        String itemsKeyword = this.isMinV202012 ? "prefixItems" : "items";
        String additionalItemsKeyword = this.isMinV202012 ? "items" : "additionalItems";
        boolean valid = false;
        int validCount = 0;
        boolean evaluated = false;
        Predicate<JsonNodeAnnotation> validEvaluationPathFilter = a -> executionContext.getResults().isValid(instanceLocation, a.getEvaluationPath());
        Predicate<JsonNodeAnnotation> adjacentEvaluationPathFilter = a -> a.getEvaluationPath().startsWith(this.evaluationPath.getParent());
        List instanceLocationAnnotations = executionContext.getAnnotations().asMap().getOrDefault(instanceLocation, Collections.emptyList());
        if (this.getSchemaNode().isBoolean() && this.getSchemaNode().booleanValue()) {
            valid = true;
            if (node.size() > 0) {
                evaluated = true;
            }
        } else {
            List items = instanceLocationAnnotations.stream().filter(a -> itemsKeyword.equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
            if (items.isEmpty()) {
                valid = false;
            } else {
                for (Object annotation : items) {
                    if (((JsonNodeAnnotation)annotation).getValue() instanceof Number) {
                        Number value = (Number)((JsonNodeAnnotation)annotation).getValue();
                        int existing = value.intValue();
                        if (existing <= validCount) continue;
                        validCount = existing;
                        continue;
                    }
                    if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Boolean)) continue;
                    valid = true;
                }
            }
            if (!valid) {
                List additionalItems = instanceLocationAnnotations.stream().filter(a -> additionalItemsKeyword.equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
                for (JsonNodeAnnotation annotation : additionalItems) {
                    if (!(annotation.getValue() instanceof Boolean) || !Boolean.TRUE.equals(annotation.getValue())) continue;
                    valid = true;
                }
            }
            if (!valid) {
                List unevaluatedItems = instanceLocationAnnotations.stream().filter(a -> "unevaluatedItems".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
                for (JsonNodeAnnotation annotation : unevaluatedItems) {
                    if (!(annotation.getValue() instanceof Boolean) || !Boolean.TRUE.equals(annotation.getValue())) continue;
                    valid = true;
                }
            }
        }
        Set<ValidationMessage> messages = null;
        if (!valid) {
            List contains = instanceLocationAnnotations.stream().filter(a -> "contains".equals(a.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
            HashSet containsEvaluated = new HashSet();
            boolean containsEvaluatedAll = false;
            for (JsonNodeAnnotation a2 : contains) {
                if (a2.getValue() instanceof List) {
                    List values = (List)a2.getValue();
                    containsEvaluated.addAll(values);
                    continue;
                }
                if (!(a2.getValue() instanceof Boolean)) continue;
                containsEvaluatedAll = true;
            }
            messages = new LinkedHashSet<ValidationMessage>();
            if (!containsEvaluatedAll) {
                for (int x = validCount; x < node.size(); ++x) {
                    if (containsEvaluated.contains(x)) continue;
                    messages.addAll(this.schema.validate(executionContext, node.get(x), node, instanceLocation.append(x)));
                    evaluated = true;
                }
            }
            if (messages.isEmpty()) {
                valid = true;
            } else {
                messages = messages.stream().map(m -> ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(m.getInstanceLocation())).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.getExecutionConfig().isFailFast())).build()).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        if (evaluated) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword("unevaluatedItems").value(true).build());
        }
        return messages == null || messages.isEmpty() ? Collections.emptySet() : messages;
    }
}

