/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultipleOfValidator.class);
    private double divisor = 0.0;

    public MultipleOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.MULTIPLE_OF, validationContext);
        if (schemaNode.isNumber()) {
            this.divisor = schemaNode.doubleValue();
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        MultipleOfValidator.debug(logger, node, rootNode, instanceLocation);
        if (node.isNumber()) {
            BigDecimal accurateDivisor;
            BigDecimal accurateDividend;
            double nodeValue = node.doubleValue();
            if (this.divisor != 0.0 && (accurateDividend = node.isBigDecimal() ? node.decimalValue() : new BigDecimal(String.valueOf(nodeValue))).divideAndRemainder(accurateDivisor = new BigDecimal(String.valueOf(this.divisor)))[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.divisor)).build());
            }
        }
        return Collections.emptySet();
    }
}

