/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.AdditionalPropertiesValidator;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ContainsValidator;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.InputFormat;
import com.networknt.schema.ItemsValidator;
import com.networknt.schema.ItemsValidator202012;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.OutputFormat;
import com.networknt.schema.PathType;
import com.networknt.schema.PatternPropertiesValidator;
import com.networknt.schema.PrefixItemsValidator;
import com.networknt.schema.PropertiesValidator;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.serialization.JsonMapperFactory;
import com.networknt.schema.serialization.YamlMapperFactory;
import com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class JsonSchema
extends BaseJsonValidator {
    private static final long V201909_VALUE = SpecVersion.VersionFlag.V201909.getVersionFlagValue();
    private List<JsonValidator> validators;
    private final JsonMetaSchema metaSchema;
    private boolean validatorsLoaded = false;
    private boolean recursiveAnchor = false;
    private JsonValidator requiredValidator = null;
    private TypeValidator typeValidator;
    WalkListenerRunner keywordWalkListenerRunner = null;
    private final String id;
    private static Comparator<JsonValidator> VALIDATOR_SORT = (lhs, rhs) -> {
        String rhsName;
        String lhsName = lhs.getEvaluationPath().getName(-1);
        if (lhsName.equals(rhsName = rhs.getEvaluationPath().getName(-1))) {
            return 0;
        }
        if (lhsName.equals("properties")) {
            return -1;
        }
        if (rhsName.equals("properties")) {
            return 1;
        }
        if (lhsName.equals("patternProperties")) {
            return -1;
        }
        if (rhsName.equals("patternProperties")) {
            return 1;
        }
        if (lhsName.equals("unevaluatedItems")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedItems")) {
            return -1;
        }
        if (lhsName.equals("unevaluatedProperties")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedProperties")) {
            return -1;
        }
        return 0;
    };

    static JsonSchema from(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        return new JsonSchema(validationContext, schemaLocation, evaluationPath, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    private boolean hasNoFragment(SchemaLocation schemaLocation) {
        return this.schemaLocation.getFragment() == null || this.schemaLocation.getFragment().getNameCount() == 0;
    }

    private JsonSchema(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaLocation.resolve(validationContext.resolveSchemaId(schemaNode)), evaluationPath, schemaNode, parent, null, null, validationContext, suppressSubSchemaRetrieval);
        String dynamicAnchor;
        this.metaSchema = this.validationContext.getMetaSchema();
        this.initializeConfig();
        String id = this.validationContext.resolveSchemaId(this.schemaNode);
        if (id != null) {
            this.id = this.hasNoFragment(schemaLocation) ? id : id;
            this.validationContext.getSchemaResources().putIfAbsent(this.schemaLocation != null ? this.schemaLocation.toString() : id, this);
        } else if (this.hasNoFragment(schemaLocation)) {
            this.id = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getSchemaResources().putIfAbsent(this.schemaLocation != null ? this.schemaLocation.toString() : this.id, this);
        } else {
            this.id = null;
        }
        String anchor = this.validationContext.getMetaSchema().readAnchor(this.schemaNode);
        if (anchor != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getSchemaResources().putIfAbsent(absoluteIri + "#" + anchor, this);
        }
        if ((dynamicAnchor = this.validationContext.getMetaSchema().readDynamicAnchor(schemaNode)) != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getDynamicAnchors().putIfAbsent(absoluteIri + "#" + dynamicAnchor, this);
        }
        this.getValidators();
    }

    private void initializeConfig() {
        if (this.validationContext.getConfig() != null) {
            this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.validationContext.getConfig().getKeywordWalkListenersMap());
        }
    }

    protected JsonSchema(JsonSchema copy) {
        super(copy);
        this.validators = copy.validators;
        this.metaSchema = copy.metaSchema;
        this.validatorsLoaded = copy.validatorsLoaded;
        this.recursiveAnchor = copy.recursiveAnchor;
        this.requiredValidator = copy.requiredValidator;
        this.typeValidator = copy.typeValidator;
        this.keywordWalkListenerRunner = copy.keywordWalkListenerRunner;
        this.id = copy.id;
    }

    public JsonSchema fromRef(JsonSchema refEvaluationParentSchema, JsonNodePath refEvaluationPath) {
        JsonSchema copy = new JsonSchema(this);
        copy.validationContext = new ValidationContext(copy.getValidationContext().getMetaSchema(), copy.getValidationContext().getJsonSchemaFactory(), refEvaluationParentSchema.validationContext.getConfig(), refEvaluationParentSchema.getValidationContext().getSchemaReferences(), refEvaluationParentSchema.getValidationContext().getSchemaResources(), refEvaluationParentSchema.getValidationContext().getDynamicAnchors());
        copy.evaluationPath = refEvaluationPath;
        copy.evaluationParentSchema = refEvaluationParentSchema;
        copy.validatorsLoaded = false;
        copy.requiredValidator = null;
        copy.typeValidator = null;
        copy.validators = null;
        copy.initializeConfig();
        return copy;
    }

    public JsonSchema withConfig(SchemaValidatorsConfig config) {
        if (!this.getValidationContext().getConfig().equals(config)) {
            JsonSchema copy = new JsonSchema(this);
            copy.validationContext = new ValidationContext(copy.getValidationContext().getMetaSchema(), copy.getValidationContext().getJsonSchemaFactory(), config, copy.getValidationContext().getSchemaReferences(), copy.getValidationContext().getSchemaResources(), copy.getValidationContext().getDynamicAnchors());
            copy.validatorsLoaded = false;
            copy.requiredValidator = null;
            copy.typeValidator = null;
            copy.validators = null;
            copy.initializeConfig();
            return copy;
        }
        return this;
    }

    ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findSchemaResourceRoot();
        JsonNode node = schema.getSchemaNode();
        String jsonPointer = ref;
        if (schema.getId() != null && ref.startsWith(schema.getId())) {
            String refValue;
            jsonPointer = refValue = ref.substring(schema.getId().length());
        }
        if (jsonPointer.startsWith("#/")) {
            jsonPointer = jsonPointer.substring(1);
        }
        if (jsonPointer.startsWith("/")) {
            try {
                jsonPointer = URLDecoder.decode(jsonPointer, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            node = node.at(jsonPointer);
            if (node.isMissingNode()) {
                node = this.handleNullNode(ref, schema);
            }
        }
        return node;
    }

    public JsonSchema getRefSchema(JsonNodePath fragment) {
        if (PathType.JSON_POINTER.equals((Object)fragment.getPathType())) {
            return this.getSubSchema(fragment);
        }
        String base = this.getSchemaLocation().getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
        String anchor = base + "#" + fragment.toString();
        JsonSchema result = (JsonSchema)this.validationContext.getSchemaResources().get(anchor);
        if (result == null) {
            result = (JsonSchema)this.validationContext.getDynamicAnchors().get(anchor);
        }
        if (result == null) {
            throw new JsonSchemaException("Unable to find anchor " + anchor);
        }
        return result;
    }

    public JsonSchema getSubSchema(JsonNodePath fragment) {
        JsonSchema document;
        JsonSchema parent = document = this.findSchemaResourceRoot();
        JsonSchema subSchema = null;
        for (int x = 0; x < fragment.getNameCount(); ++x) {
            JsonNodePath evaluationPath;
            SchemaLocation schemaLocation;
            Object segment = fragment.getElement(x);
            JsonNode subSchemaNode = parent.getNode(segment);
            if (subSchemaNode != null) {
                schemaLocation = parent.getSchemaLocation();
                evaluationPath = parent.getEvaluationPath();
                if (segment instanceof Number) {
                    int index = ((Number)segment).intValue();
                    schemaLocation = schemaLocation.append(index);
                    evaluationPath = evaluationPath.append(index);
                } else {
                    schemaLocation = schemaLocation.append(segment.toString());
                    evaluationPath = evaluationPath.append(segment.toString());
                }
            } else {
                JsonSchema found = document.findSchemaResourceRoot().fetchSubSchemaNode(this.validationContext);
                if (found != null) {
                    found = found.getSubSchema(fragment);
                }
                if (found == null) {
                    throw new JsonSchemaException("Unable to find subschema " + fragment.toString() + " in " + parent.getSchemaLocation().toString() + " at evaluation path " + parent.getEvaluationPath().toString());
                }
                return found;
            }
            parent = subSchema = parent.getValidationContext().newSchema(schemaLocation, evaluationPath, subSchemaNode, parent);
        }
        return subSchema;
    }

    protected JsonNode getNode(Object propertyOrIndex) {
        JsonNode node = this.getSchemaNode();
        JsonNode value = null;
        if (propertyOrIndex instanceof Number) {
            value = node.get(((Number)propertyOrIndex).intValue());
        } else {
            String unescaped = propertyOrIndex.toString();
            if (unescaped.contains("~")) {
                unescaped = unescaped.replace("~1", "/");
                unescaped = unescaped.replace("~0", "~");
            }
            if (unescaped.contains("%")) {
                try {
                    unescaped = URLDecoder.decode(unescaped, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            value = node.get(unescaped);
        }
        return value;
    }

    public JsonSchema findLexicalRoot() {
        JsonSchema ancestor = this;
        while (ancestor.getId() == null && null != ancestor.getParentSchema()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public JsonSchema findSchemaResourceRoot() {
        JsonSchema ancestor = this;
        while (!ancestor.isSchemaResourceRoot()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public boolean isSchemaResourceRoot() {
        if (this.getId() != null) {
            return true;
        }
        if (this.getParentSchema() == null) {
            return true;
        }
        return !Objects.equals(this.getSchemaLocation().getAbsoluteIri(), this.getParentSchema().getSchemaLocation().getAbsoluteIri());
    }

    public String getId() {
        return this.id;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private List<JsonValidator> read(JsonNode schemaNode) {
        ArrayList<JsonValidator> validators = new ArrayList<JsonValidator>();
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                JsonNodePath path = this.getEvaluationPath().append("true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("true"), path, "true", schemaNode, this);
                validators.add(validator);
            } else {
                JsonNodePath path = this.getEvaluationPath().append("false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("false"), path, "false", schemaNode, this);
                validators.add(validator);
            }
        } else {
            JsonValidator refValidator = null;
            Iterator pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                JsonValidator validator;
                String pname = (String)pnames.next();
                JsonNode nodeToUse = schemaNode.get(pname);
                JsonNodePath path = this.getEvaluationPath().append(pname);
                SchemaLocation schemaPath = this.getSchemaLocation().append(pname);
                if ("$recursiveAnchor".equals(pname)) {
                    if (!nodeToUse.isBoolean()) {
                        ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type("$recursiveAnchor")).code("internal.invalidRecursiveAnchor")).message("{0}: The value of a $recursiveAnchor must be a Boolean literal but is {1}")).instanceLocation(path)).evaluationPath(path)).schemaLocation(schemaPath)).arguments(nodeToUse.getNodeType().toString())).build();
                        throw new JsonSchemaException(validationMessage);
                    }
                    this.recursiveAnchor = nodeToUse.booleanValue();
                }
                if ((validator = this.validationContext.newValidator(schemaPath, path, pname, nodeToUse, this)) == null) continue;
                validators.add(validator);
                if ("$ref".equals(pname)) {
                    refValidator = validator;
                    continue;
                }
                if ("required".equals(pname)) {
                    this.requiredValidator = validator;
                    continue;
                }
                if (!"type".equals(pname)) continue;
                this.typeValidator = (TypeValidator)validator;
            }
            if (null != refValidator && this.activeDialect() < V201909_VALUE) {
                validators.clear();
                validators.add(refValidator);
            }
        }
        if (validators.size() > 1) {
            Collections.sort(validators, VALIDATOR_SORT);
        }
        return validators;
    }

    private long activeDialect() {
        return this.validationContext.activeDialect().map(SpecVersion.VersionFlag::getVersionFlagValue).orElse(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        DiscriminatorContext discriminatorContext;
        ObjectNode discriminator;
        ObjectNode discriminator2;
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator2 = (ObjectNode)this.schemaNode.get("discriminator")) && null != executionContext.getCurrentDiscriminatorContext()) {
            executionContext.getCurrentDiscriminatorContext().registerDiscriminator(this.schemaLocation, discriminator2);
        }
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        LinkedHashSet<ValidationMessage> errors = null;
        CollectorContext collectorContext = executionContext.getCollectorContext();
        JsonSchema.setValidatorState(executionContext, false, true);
        for (JsonValidator v : this.getValidators()) {
            CollectorContext.Scope scope;
            Set<ValidationMessage> results;
            block14: {
                results = null;
                CollectorContext.Scope parentScope = collectorContext.enterDynamicScope(this);
                try {
                    results = v.validate(executionContext, jsonNode, rootNode, instanceLocation);
                    scope = collectorContext.exitDynamicScope();
                    if (results != null && !results.isEmpty()) break block14;
                    parentScope.mergeWith(scope);
                }
                catch (Throwable throwable) {
                    CollectorContext.Scope scope2 = collectorContext.exitDynamicScope();
                    if (results == null || results.isEmpty()) {
                        parentScope.mergeWith(scope2);
                    } else {
                        if (errors == null) {
                            errors = new LinkedHashSet<ValidationMessage>();
                        }
                        errors.addAll(results);
                        if (v instanceof PrefixItemsValidator || v instanceof ItemsValidator || v instanceof ItemsValidator202012 || v instanceof ContainsValidator) {
                            collectorContext.getEvaluatedItems().addAll(scope2.getEvaluatedItems());
                        }
                        if (v instanceof PropertiesValidator || v instanceof AdditionalPropertiesValidator || v instanceof PatternPropertiesValidator) {
                            collectorContext.getEvaluatedProperties().addAll(scope2.getEvaluatedProperties());
                        }
                    }
                    throw throwable;
                }
                continue;
            }
            if (errors == null) {
                errors = new LinkedHashSet();
            }
            errors.addAll(results);
            if (v instanceof PrefixItemsValidator || v instanceof ItemsValidator || v instanceof ItemsValidator202012 || v instanceof ContainsValidator) {
                collectorContext.getEvaluatedItems().addAll(scope.getEvaluatedItems());
            }
            if (!(v instanceof PropertiesValidator) && !(v instanceof AdditionalPropertiesValidator) && !(v instanceof PatternPropertiesValidator)) continue;
            collectorContext.getEvaluatedProperties().addAll(scope.getEvaluatedProperties());
        }
        if (config.isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = executionContext.getCurrentDiscriminatorContext())) {
            ObjectNode discriminatorToUse;
            ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaLocation);
            if (null == discriminatorFromContext) {
                discriminatorContext.registerDiscriminator(this.schemaLocation, discriminator);
                discriminatorToUse = discriminator;
            } else {
                discriminatorToUse = discriminatorFromContext;
            }
            String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
            JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
            JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
        }
        return errors == null ? Collections.emptySet() : errors;
    }

    public Set<ValidationMessage> validate(JsonNode rootNode) {
        return this.validate(rootNode, OutputFormat.DEFAULT);
    }

    public Set<ValidationMessage> validate(JsonNode rootNode, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public Set<ValidationMessage> validate(JsonNode rootNode, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format) {
        return this.validate(rootNode, format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, (ExecutionContext executionContext, ValidationContext validationContext) -> executionCustomizer.accept(executionContext));
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT);
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format) {
        return this.validate(this.deserialize(input, inputFormat), format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, (ExecutionContext executionContext, ValidationContext validationContext) -> executionCustomizer.accept(executionContext));
    }

    private JsonNode deserialize(String input, InputFormat inputFormat) {
        try {
            if (InputFormat.JSON.equals((Object)inputFormat)) {
                return JsonMapperFactory.getInstance().readTree(input);
            }
            if (InputFormat.YAML.equals((Object)inputFormat)) {
                return YamlMapperFactory.getInstance().readTree(input);
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid input", e);
        }
        throw new IllegalArgumentException("Unsupported input format " + (Object)((Object)inputFormat));
    }

    public ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode node) {
        return this.validateAndCollect(executionContext, node, node, this.atRoot());
    }

    private ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = executionContext.getCollectorContext();
        JsonSchema.setValidatorState(executionContext, false, true);
        Set<ValidationMessage> errors = this.validate(executionContext, jsonNode, rootNode, instanceLocation);
        if (config.doLoadCollectors()) {
            collectorContext.loadCollectors();
        }
        ValidationResult validationResult = new ValidationResult(errors, executionContext);
        return validationResult;
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(this.createExecutionContext(), node, node, this.atRoot());
    }

    public ValidationResult walk(ExecutionContext executionContext, JsonNode node, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate);
    }

    public ValidationResult walk(ExecutionContext executionContext, String input, InputFormat inputFormat, boolean validate) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate);
    }

    public ValidationResult walk(JsonNode node, boolean validate) {
        return this.walk(this.createExecutionContext(), node, validate);
    }

    public ValidationResult walk(String input, InputFormat inputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate);
    }

    public ValidationResult walkAtNode(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, validate);
    }

    private ValidationResult walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = executionContext.getCollectorContext();
        JsonSchema.setValidatorState(executionContext, true, shouldValidateSchema);
        Set<ValidationMessage> errors = this.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
        if (config.doLoadCollectors()) {
            collectorContext.loadCollectors();
        }
        ValidationResult validationResult = new ValidationResult(errors, executionContext);
        return validationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        CollectorContext collectorContext = executionContext.getCollectorContext();
        for (JsonValidator v : this.getValidators()) {
            JsonNodePath evaluationPathWithKeyword = v.getEvaluationPath();
            try {
                if (!this.keywordWalkListenerRunner.runPreWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, v.getEvaluationPath(), v.getSchemaLocation(), this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory())) continue;
                Set<ValidationMessage> results = null;
                CollectorContext.Scope parentScope = collectorContext.enterDynamicScope(this);
                try {
                    results = v.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    CollectorContext.Scope scope = collectorContext.exitDynamicScope();
                    if (results == null || results.isEmpty()) {
                        parentScope.mergeWith(scope);
                        continue;
                    }
                    errors.addAll(results);
                    if (v instanceof PrefixItemsValidator || v instanceof ItemsValidator || v instanceof ItemsValidator202012 || v instanceof ContainsValidator) {
                        collectorContext.getEvaluatedItems().addAll(scope.getEvaluatedItems());
                    }
                    if (!(v instanceof PropertiesValidator) && !(v instanceof AdditionalPropertiesValidator) && !(v instanceof PatternPropertiesValidator)) continue;
                    collectorContext.getEvaluatedProperties().addAll(scope.getEvaluatedProperties());
                }
            }
            finally {
                this.keywordWalkListenerRunner.runPostWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, v.getEvaluationPath(), v.getSchemaLocation(), this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory(), errors);
            }
        }
        return errors;
    }

    private static void setValidatorState(ExecutionContext executionContext, boolean isWalkEnabled, boolean shouldValidateSchema) {
        ValidatorState validatorState = executionContext.getValidatorState();
        if (validatorState == null) {
            executionContext.setValidatorState(new ValidatorState(isWalkEnabled, shouldValidateSchema));
        }
    }

    @Override
    public String toString() {
        return "\"" + this.getEvaluationPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public boolean hasTypeValidator() {
        return this.getTypeValidator() != null;
    }

    public TypeValidator getTypeValidator() {
        if (this.validators == null) {
            this.getValidators();
        }
        return this.typeValidator;
    }

    public List<JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableList(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            for (JsonValidator validator : this.getValidators()) {
                validator.preloadJsonSchema();
            }
            this.validatorsLoaded = true;
        }
    }

    public boolean isRecursiveAnchor() {
        return this.recursiveAnchor;
    }

    public ExecutionContext createExecutionContext() {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = new CollectorContext(config.isUnevaluatedItemsAnalysisDisabled(), config.isUnevaluatedPropertiesAnalysisDisabled());
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLocale(config.getLocale());
        executionConfig.setFormatAssertionsEnabled(config.getFormatAssertionsEnabled());
        ExecutionContext executionContext = new ExecutionContext(executionConfig, collectorContext);
        if (config.getExecutionContextCustomizer() != null) {
            config.getExecutionContextCustomizer().customize(executionContext, this.validationContext);
        }
        return executionContext;
    }
}

