/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RecursiveRefValidator.class);
    private Map<SchemaLocation, JsonSchema> schemas = new HashMap<SchemaLocation, JsonSchema>();

    public RecursiveRefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.RECURSIVE_REF, validationContext);
        String refValue = schemaNode.asText();
        if (!"#".equals(refValue)) {
            ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type(ValidatorTypeCode.RECURSIVE_REF.getValue())).code("internal.invalidRecursiveRef")).message("{0}: The value of a $recursiveRef must be '#' but is '{1}'")).instanceLocation(schemaLocation.getFragment())).evaluationPath(schemaLocation.getFragment())).arguments(refValue)).build();
            throw new JsonSchemaException(validationMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RecursiveRefValidator.debug(logger, node, rootNode, instanceLocation);
            JsonSchema schema = collectorContext.getOutermostSchema();
            if (null != schema) {
                JsonSchema refSchema = this.schemas.computeIfAbsent(schema.getSchemaLocation(), key -> schema.fromRef(this.getParentSchema(), this.getEvaluationPath()));
                errors = refSchema.validate(executionContext, node, rootNode, instanceLocation);
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RecursiveRefValidator.debug(logger, node, rootNode, instanceLocation);
            JsonSchema schema = collectorContext.getOutermostSchema();
            if (null != schema) {
                JsonSchema refSchema = this.schemas.computeIfAbsent(schema.getSchemaLocation(), key -> schema.fromRef(this.getParentSchema(), this.getEvaluationPath()));
                errors = refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (shouldValidateSchema && errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }
}

