/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationContext;
import java.net.URI;

public class WalkEvent {
    private ExecutionContext executionContext;
    private String schemaPath;
    private JsonNode schemaNode;
    private JsonSchema parentSchema;
    private String keyWordName;
    private JsonNode node;
    private JsonNode rootNode;
    private String at;
    private JsonSchemaFactory currentJsonSchemaFactory;
    private ValidationContext validationContext;

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    public String getKeyWordName() {
        return this.keyWordName;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public String getAt() {
        return this.at;
    }

    public JsonSchema getRefSchema(URI schemaUri) {
        return this.currentJsonSchemaFactory.getSchema(schemaUri, this.validationContext.getConfig());
    }

    public JsonSchema getRefSchema(URI schemaUri, SchemaValidatorsConfig schemaValidatorsConfig) {
        if (schemaValidatorsConfig != null) {
            return this.currentJsonSchemaFactory.getSchema(schemaUri, schemaValidatorsConfig);
        }
        return this.getRefSchema(schemaUri);
    }

    public JsonSchemaFactory getCurrentJsonSchemaFactory() {
        return this.currentJsonSchemaFactory;
    }

    public static WalkEventBuilder builder() {
        return new WalkEventBuilder();
    }

    static class WalkEventBuilder {
        private WalkEvent walkEvent = new WalkEvent();

        WalkEventBuilder() {
        }

        public WalkEventBuilder executionContext(ExecutionContext executionContext) {
            this.walkEvent.executionContext = executionContext;
            return this;
        }

        public WalkEventBuilder schemaPath(String schemaPath) {
            this.walkEvent.schemaPath = schemaPath;
            return this;
        }

        public WalkEventBuilder schemaNode(JsonNode schemaNode) {
            this.walkEvent.schemaNode = schemaNode;
            return this;
        }

        public WalkEventBuilder parentSchema(JsonSchema parentSchema) {
            this.walkEvent.parentSchema = parentSchema;
            return this;
        }

        public WalkEventBuilder keyWordName(String keyWordName) {
            this.walkEvent.keyWordName = keyWordName;
            return this;
        }

        public WalkEventBuilder node(JsonNode node) {
            this.walkEvent.node = node;
            return this;
        }

        public WalkEventBuilder rootNode(JsonNode rootNode) {
            this.walkEvent.rootNode = rootNode;
            return this;
        }

        public WalkEventBuilder at(String at) {
            this.walkEvent.at = at;
            return this;
        }

        public WalkEventBuilder currentJsonSchemaFactory(JsonSchemaFactory currentJsonSchemaFactory) {
            this.walkEvent.currentJsonSchemaFactory = currentJsonSchemaFactory;
            return this;
        }

        public WalkEventBuilder validationContext(ValidationContext validationContext) {
            this.walkEvent.validationContext = validationContext;
            return this;
        }

        public WalkEvent build() {
            return this.walkEvent;
        }
    }
}

