/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.AdditionalPropertiesValidator;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ContainsValidator;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.ItemsValidator;
import com.networknt.schema.ItemsValidator202012;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.PatternPropertiesValidator;
import com.networknt.schema.PrefixItemsValidator;
import com.networknt.schema.PropertiesValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ThreadInfo;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.StringUtils;
import com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class JsonSchema
extends BaseJsonValidator {
    private static final long V201909_VALUE = SpecVersion.VersionFlag.V201909.getVersionFlagValue();
    private Map<String, JsonValidator> validators;
    private final JsonMetaSchema metaSchema;
    private boolean validatorsLoaded = false;
    private URI currentUri;
    private JsonValidator requiredValidator = null;
    private TypeValidator typeValidator;
    WalkListenerRunner keywordWalkListenerRunner = null;
    private static Comparator<String> VALIDATOR_SORT = (lhs, rhs) -> {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.endsWith("/properties")) {
            return -1;
        }
        if (rhs.endsWith("/properties")) {
            return 1;
        }
        if (lhs.endsWith("/patternProperties")) {
            return -1;
        }
        if (rhs.endsWith("/patternProperties")) {
            return 1;
        }
        if (lhs.endsWith("/unevaluatedItems")) {
            return 1;
        }
        if (rhs.endsWith("/unevaluatedItems")) {
            return -1;
        }
        if (lhs.endsWith("/unevaluatedProperties")) {
            return 1;
        }
        if (rhs.endsWith("/unevaluatedProperties")) {
            return -1;
        }
        return lhs.compareTo((String)rhs);
    };

    static JsonSchema from(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        return new JsonSchema(validationContext, schemaPath, currentUri, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    @Deprecated
    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode) {
        this(validationContext, "#", baseUri, schemaNode, null);
    }

    @Deprecated
    public JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent) {
        this(validationContext, schemaPath, currentUri, schemaNode, parent, false);
    }

    @Deprecated
    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode, boolean suppressSubSchemaRetrieval) {
        this(validationContext, "#", baseUri, schemaNode, null, suppressSubSchemaRetrieval);
    }

    private JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaPath, schemaNode, parent, null, validationContext, suppressSubSchemaRetrieval);
        this.validationContext = validationContext;
        this.metaSchema = validationContext.getMetaSchema();
        this.currentUri = this.combineCurrentUriWithIds(currentUri, schemaNode);
        if (JsonSchema.uriRefersToSubschema(currentUri, schemaPath)) {
            this.updateThisAsSubschema(currentUri);
        }
        if (validationContext.getConfig() != null) {
            ObjectNode discriminator;
            this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.validationContext.getConfig().getKeywordWalkListenersMap());
            if (validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)schemaNode.get("discriminator")) && null != validationContext.getCurrentDiscriminatorContext()) {
                validationContext.getCurrentDiscriminatorContext().registerDiscriminator(schemaPath, discriminator);
            }
        }
    }

    public JsonSchema createChildSchema(String schemaPath, JsonNode schemaNode) {
        return this.getValidationContext().newSchema(schemaPath, schemaNode, this);
    }

    ValidationContext getValidationContext() {
        return this.validationContext;
    }

    private URI combineCurrentUriWithIds(URI currentUri, JsonNode schemaNode) {
        String id = this.validationContext.resolveSchemaId(schemaNode);
        if (id == null) {
            return currentUri;
        }
        if (JsonSchema.isUriFragmentWithNoContext(currentUri, id)) {
            return null;
        }
        try {
            return this.validationContext.getURIFactory().create(currentUri, id);
        }
        catch (IllegalArgumentException e) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.ID.getValue(), (ErrorMessageType)ValidatorTypeCode.ID, new MessageFormat(this.validationContext.getConfig().getResourceBundle().getString(ValidatorTypeCode.ID.getErrorCodeValue())), id, this.schemaPath, currentUri == null ? "null" : currentUri.toString()));
        }
    }

    private static boolean isUriFragmentWithNoContext(URI currentUri, String id) {
        return id.startsWith("#") && currentUri == null;
    }

    private static boolean uriRefersToSubschema(URI originalUri, String schemaPath) {
        return originalUri != null && StringUtils.isNotBlank(originalUri.getRawFragment()) && (StringUtils.isBlank(schemaPath) || "#".equals(schemaPath));
    }

    private void updateThisAsSubschema(URI originalUri) {
        URI currentUriWithoutFragment;
        String fragment = "#" + originalUri.getFragment();
        JsonNode fragmentSchemaNode = this.getRefSchemaNode(fragment);
        if (fragmentSchemaNode == null) {
            throw new JsonSchemaException("Fragment " + fragment + " cannot be resolved");
        }
        try {
            currentUriWithoutFragment = new URI(this.currentUri.getScheme(), this.currentUri.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException ex) {
            throw new JsonSchemaException("Unable to create URI without fragment from " + this.currentUri + ": " + ex.getMessage());
        }
        this.parentSchema = new JsonSchema(this.validationContext, this.schemaPath, currentUriWithoutFragment, this.schemaNode, this.parentSchema, this.suppressSubSchemaRetrieval);
        this.schemaPath = fragment;
        this.schemaNode = fragmentSchemaNode;
        this.currentUri = this.combineCurrentUriWithIds(this.currentUri, fragmentSchemaNode);
    }

    public URI getCurrentUri() {
        return this.currentUri;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findAncestor();
        JsonNode node = schema.getSchemaNode();
        String jsonPointer = ref;
        if (jsonPointer.startsWith("#/")) {
            jsonPointer = ref.substring(1);
        }
        if (jsonPointer.startsWith("/")) {
            try {
                jsonPointer = URLDecoder.decode(jsonPointer, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            node = node.at(jsonPointer);
            if (node.isMissingNode()) {
                node = this.handleNullNode(ref, schema);
            }
        } else if (ref.startsWith("#") && ref.length() > 1 && (node = this.metaSchema.getNodeByFragmentRef(ref, node)) == null) {
            node = this.handleNullNode(ref, schema);
        }
        return node;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private Map<String, JsonValidator> read(JsonNode schemaNode) {
        TreeMap<String, JsonValidator> validators = new TreeMap<String, JsonValidator>(VALIDATOR_SORT);
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                String customMessage = this.getCustomMessage(schemaNode, "true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "true", schemaNode, this, customMessage);
                validators.put(this.getSchemaPath() + "/true", validator);
            } else {
                String customMessage = this.getCustomMessage(schemaNode, "false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "false", schemaNode, this, customMessage);
                validators.put(this.getSchemaPath() + "/false", validator);
            }
        } else {
            JsonValidator refValidator = null;
            Iterator pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                String pname = (String)pnames.next();
                JsonNode nodeToUse = pname.equals("if") ? schemaNode : schemaNode.get(pname);
                String customMessage = this.getCustomMessage(schemaNode, pname);
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), pname, nodeToUse, this, customMessage);
                if (validator == null) continue;
                validators.put(this.getSchemaPath() + "/" + pname, validator);
                if ("$ref".equals(pname)) {
                    refValidator = validator;
                }
                if ("required".equals(pname)) {
                    this.requiredValidator = validator;
                }
                if (!"type".equals(pname)) continue;
                this.typeValidator = (TypeValidator)validator;
            }
            if (null != refValidator && this.activeDialect() < V201909_VALUE) {
                validators.clear();
                validators.put(this.getSchemaPath() + "/$ref", refValidator);
            }
        }
        return validators;
    }

    private long activeDialect() {
        return this.validationContext.activeDialect().map(SpecVersion.VersionFlag::getVersionFlagValue).orElse(Long.MAX_VALUE);
    }

    private String getCustomMessage(JsonNode schemaNode, String pname) {
        if (!this.validationContext.getConfig().isCustomMessageSupported()) {
            return null;
        }
        JsonSchema parentSchema = this.getParentSchema();
        JsonNode message = this.getMessageNode(schemaNode, parentSchema, pname);
        if (message != null && message.get(pname) != null) {
            return message.get(pname).asText();
        }
        return null;
    }

    private JsonNode getMessageNode(JsonNode schemaNode, JsonSchema parentSchema, String pname) {
        if (schemaNode.get("message") != null && schemaNode.get("message").get(pname) != null) {
            return schemaNode.get("message");
        }
        JsonNode messageNode = schemaNode.get("message");
        if (messageNode == null && parentSchema != null && (messageNode = parentSchema.schemaNode.get("message")) == null) {
            return this.getMessageNode(parentSchema.schemaNode, parentSchema.getParentSchema(), pname);
        }
        return messageNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode jsonNode, JsonNode rootNode, String at) {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        LinkedHashSet<Object> errors = new LinkedHashSet<Object>();
        CollectorContext collectorContext = this.getCollectorContext();
        JsonSchema.setValidatorState(false, true);
        try {
            ValidationContext.DiscriminatorContext discriminatorContext;
            ObjectNode discriminator;
            for (JsonValidator v : this.getValidators().values()) {
                Set<Object> results = Collections.emptySet();
                CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
                try {
                    results = v.validate(jsonNode, rootNode, at);
                }
                finally {
                    CollectorContext.Scope scope = collectorContext.exitDynamicScope();
                    if (results.isEmpty()) {
                        parentScope.mergeWith(scope);
                        continue;
                    }
                    errors.addAll(results);
                    if (v instanceof PrefixItemsValidator || v instanceof ItemsValidator || v instanceof ItemsValidator202012 || v instanceof ContainsValidator) {
                        collectorContext.getEvaluatedItems().addAll(scope.getEvaluatedItems());
                    }
                    if (!(v instanceof PropertiesValidator) && !(v instanceof AdditionalPropertiesValidator) && !(v instanceof PatternPropertiesValidator)) continue;
                    collectorContext.getEvaluatedProperties().addAll(scope.getEvaluatedProperties());
                }
            }
            if (config.isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = this.validationContext.getCurrentDiscriminatorContext())) {
                ObjectNode discriminatorToUse;
                ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaPath);
                if (null == discriminatorFromContext) {
                    discriminatorContext.registerDiscriminator(this.schemaPath, discriminator);
                    discriminatorToUse = discriminator;
                } else {
                    discriminatorToUse = discriminatorFromContext;
                }
                String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
                JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
                String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
                JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
            }
            LinkedHashSet<Object> linkedHashSet = errors;
            return linkedHashSet;
        }
        finally {
            if (collectorContext.getDynamicScope().isTop() && config.isResetCollectorContext()) {
                collectorContext.reset();
            }
        }
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(node, node, this.atRoot());
    }

    private ValidationResult validateAndCollect(JsonNode jsonNode, JsonNode rootNode, String at) {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = this.getCollectorContext();
        JsonSchema.setValidatorState(false, true);
        Set<ValidationMessage> errors = this.validate(jsonNode, rootNode, at);
        if (config.doLoadCollectors()) {
            collectorContext.loadCollectors();
        }
        ValidationResult validationResult = new ValidationResult(errors, collectorContext);
        return validationResult;
    }

    public ValidationResult walk(JsonNode node, boolean shouldValidateSchema) {
        return this.walkAtNodeInternal(node, node, this.atRoot(), shouldValidateSchema);
    }

    public ValidationResult walkAtNode(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        return this.walkAtNodeInternal(node, rootNode, at, shouldValidateSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult walkAtNodeInternal(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        try {
            ValidationResult validationResult;
            SchemaValidatorsConfig config = this.validationContext.getConfig();
            CollectorContext collectorContext = this.getCollectorContext();
            JsonSchema.setValidatorState(true, shouldValidateSchema);
            Set<ValidationMessage> errors = this.walk(node, rootNode, at, shouldValidateSchema);
            if (config.doLoadCollectors()) {
                collectorContext.loadCollectors();
            }
            ValidationResult validationResult2 = validationResult = new ValidationResult(errors, collectorContext);
            return validationResult2;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        this.getValidators().forEach((schemaPathWithKeyword, jsonWalker) -> {
            try {
                if (this.keywordWalkListenerRunner.runPreWalkListeners((String)schemaPathWithKeyword, node, rootNode, at, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory())) {
                    validationMessages.addAll(jsonWalker.walk(node, rootNode, at, shouldValidateSchema));
                }
            }
            finally {
                this.keywordWalkListenerRunner.runPostWalkListeners((String)schemaPathWithKeyword, node, rootNode, at, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory(), (Set<ValidationMessage>)validationMessages);
            }
        });
        return validationMessages;
    }

    private static void setValidatorState(boolean isWalkEnabled, boolean shouldValidateSchema) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Object stateObj = collectorContext.get("com.networknt.schema.ValidatorState");
        if (stateObj == null) {
            ValidatorState state = new ValidatorState();
            state.setWalkEnabled(isWalkEnabled);
            state.setValidationEnabled(shouldValidateSchema);
            collectorContext.add("com.networknt.schema.ValidatorState", state);
        }
    }

    public CollectorContext getCollectorContext() {
        return (CollectorContext)ThreadInfo.computeIfAbsent("com.networknt.schema.CollectorKey", k -> Optional.ofNullable(this.validationContext.getConfig()).map(SchemaValidatorsConfig::getCollectorContext).orElseGet(() -> Optional.ofNullable(this.validationContext.getConfig()).map(config -> new CollectorContext(config.isUnevaluatedItemsAnalysisDisabled(), config.isUnevaluatedPropertiesAnalysisDisabled())).orElseGet(() -> new CollectorContext(false, false))));
    }

    public String toString() {
        return "\"" + this.getSchemaPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public boolean hasTypeValidator() {
        return this.typeValidator != null;
    }

    public TypeValidator getTypeValidator() {
        return this.typeValidator;
    }

    private Map<String, JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableMap(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            this.validatorsLoaded = true;
            for (JsonValidator validator : this.getValidators().values()) {
                validator.preloadJsonSchema();
            }
        }
    }
}

