/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ThreadInfo;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.StringUtils;
import com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonSchema
extends BaseJsonValidator {
    private static final Pattern intPattern = Pattern.compile("^[0-9]+$");
    private Map<String, JsonValidator> validators;
    private final JsonMetaSchema metaSchema;
    private boolean validatorsLoaded = false;
    private URI currentUri;
    private JsonValidator requiredValidator = null;
    private TypeValidator typeValidator;
    WalkListenerRunner keywordWalkListenerRunner = null;
    private static Comparator<String> VALIDATOR_SORT = (lhs, rhs) -> {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.endsWith("/properties")) {
            return -1;
        }
        if (rhs.endsWith("/properties")) {
            return 1;
        }
        if (lhs.endsWith("/patternProperties")) {
            return -1;
        }
        if (rhs.endsWith("/patternProperties")) {
            return 1;
        }
        if (lhs.endsWith("/unevaluatedItems")) {
            return 1;
        }
        if (rhs.endsWith("/unevaluatedItems")) {
            return -1;
        }
        if (lhs.endsWith("/unevaluatedProperties")) {
            return 1;
        }
        if (rhs.endsWith("/unevaluatedProperties")) {
            return -1;
        }
        return lhs.compareTo((String)rhs);
    };

    static JsonSchema from(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        return new JsonSchema(validationContext, schemaPath, currentUri, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    @Deprecated
    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode) {
        this(validationContext, "#", baseUri, schemaNode, null);
    }

    @Deprecated
    public JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent) {
        this(validationContext, schemaPath, currentUri, schemaNode, parent, false);
    }

    @Deprecated
    public JsonSchema(ValidationContext validationContext, URI baseUri, JsonNode schemaNode, boolean suppressSubSchemaRetrieval) {
        this(validationContext, "#", baseUri, schemaNode, null, suppressSubSchemaRetrieval);
    }

    private JsonSchema(ValidationContext validationContext, String schemaPath, URI currentUri, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(schemaPath, schemaNode, parent, null, validationContext, suppressSubSchemaRetrieval);
        this.validationContext = validationContext;
        this.metaSchema = validationContext.getMetaSchema();
        this.currentUri = this.combineCurrentUriWithIds(currentUri, schemaNode);
        if (JsonSchema.uriRefersToSubschema(currentUri, schemaPath)) {
            this.updateThisAsSubschema(currentUri);
        }
        if (validationContext.getConfig() != null) {
            ObjectNode discriminator;
            this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.validationContext.getConfig().getKeywordWalkListenersMap());
            if (validationContext.getConfig().isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)schemaNode.get("discriminator")) && null != validationContext.getCurrentDiscriminatorContext()) {
                validationContext.getCurrentDiscriminatorContext().registerDiscriminator(schemaPath, discriminator);
            }
        }
    }

    public JsonSchema createChildSchema(String schemaPath, JsonNode schemaNode) {
        return this.getValidationContext().newSchema(schemaPath, schemaNode, this);
    }

    ValidationContext getValidationContext() {
        return this.validationContext;
    }

    private URI combineCurrentUriWithIds(URI currentUri, JsonNode schemaNode) {
        String id = this.validationContext.resolveSchemaId(schemaNode);
        if (id == null) {
            return currentUri;
        }
        if (JsonSchema.isUriFragmentWithNoContext(currentUri, id)) {
            return null;
        }
        try {
            return this.validationContext.getURIFactory().create(currentUri, id);
        }
        catch (IllegalArgumentException e) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.ID.getValue(), (ErrorMessageType)ValidatorTypeCode.ID, new MessageFormat(this.validationContext.getConfig().getResourceBundle().getString(ValidatorTypeCode.ID.getErrorCodeValue())), id, this.schemaPath, currentUri == null ? "null" : currentUri.toString()));
        }
    }

    private static boolean isUriFragmentWithNoContext(URI currentUri, String id) {
        return id.startsWith("#") && currentUri == null;
    }

    private static boolean uriRefersToSubschema(URI originalUri, String schemaPath) {
        return originalUri != null && StringUtils.isNotBlank(originalUri.getRawFragment()) && (StringUtils.isBlank(schemaPath) || "#".equals(schemaPath));
    }

    private void updateThisAsSubschema(URI originalUri) {
        URI currentUriWithoutFragment;
        String fragment = "#" + originalUri.getFragment();
        JsonNode fragmentSchemaNode = this.getRefSchemaNode(fragment);
        if (fragmentSchemaNode == null) {
            throw new JsonSchemaException("Fragment " + fragment + " cannot be resolved");
        }
        try {
            currentUriWithoutFragment = new URI(this.currentUri.getScheme(), this.currentUri.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException ex) {
            throw new JsonSchemaException("Unable to create URI without fragment from " + this.currentUri + ": " + ex.getMessage());
        }
        this.parentSchema = new JsonSchema(this.validationContext, this.schemaPath, currentUriWithoutFragment, this.schemaNode, this.parentSchema, this.suppressSubSchemaRetrieval);
        this.schemaPath = fragment;
        this.schemaNode = fragmentSchemaNode;
        this.currentUri = this.combineCurrentUriWithIds(this.currentUri, fragmentSchemaNode);
    }

    public URI getCurrentUri() {
        return this.currentUri;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findAncestor();
        JsonNode node = schema.getSchemaNode();
        if (ref.startsWith("#/")) {
            String[] keys;
            for (String key : keys = ref.substring(2).split("/")) {
                try {
                    key = URLDecoder.decode(key, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                Matcher matcher = intPattern.matcher(key);
                node = matcher.matches() ? node.get(Integer.parseInt(key)) : node.get(key);
                if (node == null) {
                    node = this.handleNullNode(ref, schema);
                }
                if (node != null) {
                    continue;
                }
                break;
            }
        } else if (ref.startsWith("#") && ref.length() > 1 && (node = this.metaSchema.getNodeByFragmentRef(ref, node)) == null) {
            node = this.handleNullNode(ref, schema);
        }
        return node;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private Map<String, JsonValidator> read(JsonNode schemaNode) {
        TreeMap<String, JsonValidator> validators = new TreeMap<String, JsonValidator>(VALIDATOR_SORT);
        if (schemaNode.isBoolean()) {
            if (schemaNode.booleanValue()) {
                String customMessage = this.getCustomMessage(schemaNode, "true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "true", schemaNode, this, customMessage);
                validators.put(this.getSchemaPath() + "/true", validator);
            } else {
                String customMessage = this.getCustomMessage(schemaNode, "false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), "false", schemaNode, this, customMessage);
                validators.put(this.getSchemaPath() + "/false", validator);
            }
        } else {
            Iterator pnames = schemaNode.fieldNames();
            while (pnames.hasNext()) {
                String pname = (String)pnames.next();
                JsonNode nodeToUse = pname.equals("if") ? schemaNode : schemaNode.get(pname);
                String customMessage = this.getCustomMessage(schemaNode, pname);
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaPath(), pname, nodeToUse, this, customMessage);
                if (validator == null) continue;
                validators.put(this.getSchemaPath() + "/" + pname, validator);
                if ("required".equals(pname)) {
                    this.requiredValidator = validator;
                }
                if (!"type".equals(pname)) continue;
                this.typeValidator = (TypeValidator)validator;
            }
        }
        return validators;
    }

    private String getCustomMessage(JsonNode schemaNode, String pname) {
        JsonSchema parentSchema = this.getParentSchema();
        JsonNode message = this.getMessageNode(schemaNode, parentSchema, pname);
        if (message != null && message.get(pname) != null) {
            return message.get(pname).asText();
        }
        return null;
    }

    private JsonNode getMessageNode(JsonNode schemaNode, JsonSchema parentSchema, String pname) {
        if (schemaNode.get("message") != null && schemaNode.get("message").get(pname) != null) {
            return schemaNode.get("message");
        }
        JsonNode messageNode = schemaNode.get("message");
        if (messageNode == null && parentSchema != null && (messageNode = parentSchema.schemaNode.get("message")) == null) {
            return this.getMessageNode(parentSchema.schemaNode, parentSchema.getParentSchema(), pname);
        }
        return messageNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        try {
            Set<ValidationMessage> errors;
            Set<ValidationMessage> set = errors = this.validate(node, node, this.atRoot());
            return set;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode jsonNode, JsonNode rootNode, String at) {
        ValidationContext.DiscriminatorContext discriminatorContext;
        ObjectNode discriminator;
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        this.getCollectorContext();
        JsonSchema.setValidatorState(false, true);
        for (JsonValidator v : this.getValidators().values()) {
            errors.addAll(v.validate(jsonNode, rootNode, at));
        }
        if (null != config && config.isOpenAPI3StyleDiscriminators() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = this.validationContext.getCurrentDiscriminatorContext())) {
            ObjectNode discriminatorToUse;
            ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaPath);
            if (null == discriminatorFromContext) {
                discriminatorContext.registerDiscriminator(this.schemaPath, discriminator);
                discriminatorToUse = discriminator;
            } else {
                discriminatorToUse = discriminatorFromContext;
            }
            String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
            JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
            JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
        }
        return errors;
    }

    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(node, node, this.atRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateAndCollect(JsonNode jsonNode, JsonNode rootNode, String at) {
        try {
            ValidationResult validationResult;
            SchemaValidatorsConfig config = this.validationContext.getConfig();
            CollectorContext collectorContext = this.getCollectorContext();
            JsonSchema.setValidatorState(false, true);
            Set<ValidationMessage> errors = this.validate(jsonNode, rootNode, at);
            if (config.doLoadCollectors()) {
                collectorContext.loadCollectors();
            }
            ValidationResult validationResult2 = validationResult = new ValidationResult(errors, collectorContext);
            return validationResult2;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    public ValidationResult walk(JsonNode node, boolean shouldValidateSchema) {
        return this.walkAtNodeInternal(node, node, this.atRoot(), shouldValidateSchema);
    }

    public ValidationResult walkAtNode(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        return this.walkAtNodeInternal(node, rootNode, at, shouldValidateSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult walkAtNodeInternal(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        try {
            ValidationResult validationResult;
            SchemaValidatorsConfig config = this.validationContext.getConfig();
            CollectorContext collectorContext = this.getCollectorContext();
            JsonSchema.setValidatorState(true, shouldValidateSchema);
            Set<ValidationMessage> errors = this.walk(node, rootNode, at, shouldValidateSchema);
            if (config.doLoadCollectors()) {
                collectorContext.loadCollectors();
            }
            ValidationResult validationResult2 = validationResult = new ValidationResult(errors, collectorContext);
            return validationResult2;
        }
        finally {
            if (this.validationContext.getConfig().isResetCollectorContext()) {
                CollectorContext.getInstance().reset();
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        this.getValidators().forEach((schemaPathWithKeyword, jsonWalker) -> {
            try {
                if (this.keywordWalkListenerRunner.runPreWalkListeners((String)schemaPathWithKeyword, node, rootNode, at, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory())) {
                    validationMessages.addAll(jsonWalker.walk(node, rootNode, at, shouldValidateSchema));
                }
            }
            finally {
                this.keywordWalkListenerRunner.runPostWalkListeners((String)schemaPathWithKeyword, node, rootNode, at, this.schemaPath, this.schemaNode, this.parentSchema, this.validationContext, this.validationContext.getJsonSchemaFactory(), (Set<ValidationMessage>)validationMessages);
            }
        });
        return validationMessages;
    }

    private static void setValidatorState(boolean isWalkEnabled, boolean shouldValidateSchema) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Object stateObj = collectorContext.get("com.networknt.schema.ValidatorState");
        if (stateObj == null) {
            ValidatorState state = new ValidatorState();
            state.setWalkEnabled(isWalkEnabled);
            state.setValidationEnabled(shouldValidateSchema);
            collectorContext.add("com.networknt.schema.ValidatorState", state);
        }
    }

    public CollectorContext getCollectorContext() {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        CollectorContext collectorContext = (CollectorContext)ThreadInfo.get("com.networknt.schema.CollectorKey");
        if (collectorContext == null) {
            collectorContext = config != null && config.getCollectorContext() != null ? config.getCollectorContext() : new CollectorContext();
            ThreadInfo.set("com.networknt.schema.CollectorKey", collectorContext);
        }
        return collectorContext;
    }

    public String toString() {
        return "\"" + this.getSchemaPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasRequiredValidator() {
        return this.requiredValidator != null;
    }

    public JsonValidator getRequiredValidator() {
        return this.requiredValidator;
    }

    public boolean hasTypeValidator() {
        return this.typeValidator != null;
    }

    public TypeValidator getTypeValidator() {
        return this.typeValidator;
    }

    private Map<String, JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableMap(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            this.validatorsLoaded = true;
            for (JsonValidator validator : this.getValidators().values()) {
                validator.preloadJsonSchema();
            }
        }
    }
}

