/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            String schemaPathOfSchema = parentSchema.schemaPath + "/" + keyword;
            if (keyword.equals("if")) {
                foundIfSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = new JsonSchema(validationContext, schemaPathOfSchema, parentSchema.getCurrentUri(), node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        LinkedHashSet<ValidationMessage> errors;
        block16: {
            Object backupEvaluatedProperties;
            block15: {
                List backupEvaluatedPropertiesList;
                this.debug(logger, node, rootNode, at);
                backupEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                Object ifEvaluatedProperties = null;
                Object thenEvaluatedProperties = null;
                Object elseEvaluatedProperties = null;
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                errors = new LinkedHashSet<ValidationMessage>();
                boolean ifConditionPassed = false;
                try {
                    try {
                        ifConditionPassed = this.ifSchema.validate(node, rootNode, at).isEmpty();
                    }
                    catch (JsonSchemaException ex) {
                        ifConditionPassed = false;
                    }
                    ifEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                    if (ifConditionPassed && this.thenSchema != null) {
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                        errors.addAll(this.thenSchema.validate(node, rootNode, at));
                        thenEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                    } else if (!ifConditionPassed && this.elseSchema != null) {
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
                        errors.addAll(this.elseSchema.validate(node, rootNode, at));
                        elseEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
                    }
                    if (!errors.isEmpty()) break block15;
                    List list = backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                }
                catch (Throwable throwable) {
                    if (errors.isEmpty()) {
                        List backupEvaluatedPropertiesList2;
                        List list = backupEvaluatedPropertiesList2 = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
                        if (ifEvaluatedProperties != null && ifConditionPassed) {
                            backupEvaluatedPropertiesList2.addAll((List)ifEvaluatedProperties);
                        }
                        if (thenEvaluatedProperties != null) {
                            backupEvaluatedPropertiesList2.addAll((List)thenEvaluatedProperties);
                        }
                        if (elseEvaluatedProperties != null) {
                            backupEvaluatedPropertiesList2.addAll((List)elseEvaluatedProperties);
                        }
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList2);
                    } else {
                        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
                    }
                    throw throwable;
                }
                if (ifEvaluatedProperties != null && ifConditionPassed) {
                    backupEvaluatedPropertiesList.addAll((List)ifEvaluatedProperties);
                }
                if (thenEvaluatedProperties != null) {
                    backupEvaluatedPropertiesList.addAll((List)thenEvaluatedProperties);
                }
                if (elseEvaluatedProperties != null) {
                    backupEvaluatedPropertiesList.addAll((List)elseEvaluatedProperties);
                }
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
                break block16;
            }
            CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }
}

