/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.StringUtils;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public abstract class BaseJsonValidator
implements JsonValidator {
    protected String schemaPath;
    protected JsonNode schemaNode;
    protected JsonSchema parentSchema;
    private boolean suppressSubSchemaRetrieval;
    private ValidatorTypeCode validatorType;
    private ErrorMessageType errorMessageType;
    protected ValidationContext validationContext;
    protected final boolean failFast;
    protected final ApplyDefaultsStrategy applyDefaultsStrategy;

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        this(schemaPath, schemaNode, parentSchema, validatorType, false, validationContext.getConfig() != null && validationContext.getConfig().isFailFast(), validationContext.getConfig() != null ? validationContext.getConfig().getApplyDefaultsStrategy() : null);
    }

    @Deprecated
    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, boolean suppressSubSchemaRetrieval, boolean failFast) {
        this(schemaPath, schemaNode, parentSchema, validatorType, false, failFast, null);
    }

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, boolean suppressSubSchemaRetrieval, boolean failFast, ApplyDefaultsStrategy applyDefaultsStrategy) {
        this.errorMessageType = validatorType;
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
        this.failFast = failFast;
        this.applyDefaultsStrategy = applyDefaultsStrategy != null ? applyDefaultsStrategy : ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    protected JsonSchema fetchSubSchemaNode(ValidationContext validationContext) {
        return this.suppressSubSchemaRetrieval ? null : BaseJsonValidator.obtainSubSchemaNode(this.schemaNode, validationContext);
    }

    private static JsonSchema obtainSubSchemaNode(JsonNode schemaNode, ValidationContext validationContext) {
        URI uri;
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals((Object)schemaNode.get("$schema"))) {
            return null;
        }
        String text = node.textValue();
        if (text == null) {
            return null;
        }
        try {
            uri = validationContext.getURIFactory().create(node.textValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return validationContext.getJsonSchemaFactory().getSchema(uri, validationContext.getConfig());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    protected boolean greaterThan(double n1, double n2) {
        return n1 - n2 > 1.0E-12;
    }

    protected boolean lessThan(double n1, double n2) {
        return n1 - n2 < -1.0E-12;
    }

    protected void parseErrorCode(String errorCodeKey) {
        String errorCodeText;
        JsonNode errorCodeNode = this.getParentSchema().getSchemaNode().get(errorCodeKey);
        if (errorCodeNode != null && errorCodeNode.isTextual() && StringUtils.isNotBlank(errorCodeText = errorCodeNode.asText())) {
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
        }
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        ValidationMessage message = ValidationMessage.of(this.getValidatorType().getValue(), this.errorMessageType, at, this.schemaPath, arguments);
        if (this.failFast && !this.isPartOfOneOfMultipleType()) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected void debug(Logger logger, JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            logger.debug("validate( " + node + ", " + rootNode + ", " + at + ")");
        }
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        Set<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages = this.validate(node, rootNode, at);
        }
        return validationMessages;
    }

    protected void preloadJsonSchemas(Collection<JsonSchema> schemas) {
        for (JsonSchema schema : schemas) {
            schema.initializeValidators();
        }
    }

    protected boolean isPartOfOneOfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.ONE_OF.getValue() + "/");
    }

    protected static void checkDiscriminatorMatch(ValidationContext.DiscriminatorContext currentDiscriminatorContext, ObjectNode discriminator, String discriminatorPropertyValue, JsonSchema jsonSchema) {
        if (discriminatorPropertyValue == null) {
            currentDiscriminatorContext.markMatch();
            return;
        }
        JsonNode discriminatorMapping = discriminator.get("mapping");
        if (null == discriminatorMapping) {
            BaseJsonValidator.checkForImplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, jsonSchema);
        } else {
            BaseJsonValidator.checkForExplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, discriminatorMapping, jsonSchema);
            if (!currentDiscriminatorContext.isDiscriminatorMatchFound() && BaseJsonValidator.noExplicitDiscriminatorKeyOverride(discriminatorMapping, jsonSchema)) {
                BaseJsonValidator.checkForImplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, jsonSchema);
            }
        }
    }

    protected static void registerAndMergeDiscriminator(ValidationContext.DiscriminatorContext currentDiscriminatorContext, ObjectNode discriminator, JsonSchema schema, String at) {
        JsonNode discriminatorOnSchema = schema.schemaNode.get("discriminator");
        if (null != discriminatorOnSchema && null != currentDiscriminatorContext.getDiscriminatorForPath(schema.schemaPath)) {
            JsonNode propertyName = discriminatorOnSchema.get("propertyName");
            if (null != propertyName) {
                throw new JsonSchemaException(at + " schema " + schema + " attempts redefining the discriminator property");
            }
            ObjectNode mappingOnContextDiscriminator = (ObjectNode)discriminator.get("mapping");
            ObjectNode mappingOnCurrentSchemaDiscriminator = (ObjectNode)discriminatorOnSchema.get("mapping");
            if (null == mappingOnContextDiscriminator && null != mappingOnCurrentSchemaDiscriminator) {
                discriminator.set("mapping", discriminatorOnSchema);
            } else if (null != mappingOnContextDiscriminator && null != mappingOnCurrentSchemaDiscriminator) {
                Iterator fieldsToAdd = mappingOnCurrentSchemaDiscriminator.fields();
                while (fieldsToAdd.hasNext()) {
                    Map.Entry fieldToAdd = (Map.Entry)fieldsToAdd.next();
                    String mappingKeyToAdd = (String)fieldToAdd.getKey();
                    JsonNode mappingValueToAdd = (JsonNode)fieldToAdd.getValue();
                    JsonNode currentMappingValue = mappingOnContextDiscriminator.get(mappingKeyToAdd);
                    if (null != currentMappingValue && currentMappingValue != mappingValueToAdd) {
                        throw new JsonSchemaException(at + "discriminator mapping redefinition from " + mappingKeyToAdd + "/" + currentMappingValue + " to " + mappingValueToAdd);
                    }
                    if (null != currentMappingValue) continue;
                    mappingOnContextDiscriminator.set(mappingKeyToAdd, mappingValueToAdd);
                }
            }
        }
        currentDiscriminatorContext.registerDiscriminator(schema.schemaPath, discriminator);
    }

    private static void checkForImplicitDiscriminatorMappingMatch(ValidationContext.DiscriminatorContext currentDiscriminatorContext, String discriminatorPropertyValue, JsonSchema schema) {
        if (schema.schemaPath.endsWith("/" + discriminatorPropertyValue)) {
            currentDiscriminatorContext.markMatch();
        }
    }

    private static void checkForExplicitDiscriminatorMappingMatch(ValidationContext.DiscriminatorContext currentDiscriminatorContext, String discriminatorPropertyValue, JsonNode discriminatorMapping, JsonSchema schema) {
        Iterator explicitMappings = discriminatorMapping.fields();
        while (explicitMappings.hasNext()) {
            Map.Entry candidateExplicitMapping = (Map.Entry)explicitMappings.next();
            if (!((String)candidateExplicitMapping.getKey()).equals(discriminatorPropertyValue) || !schema.schemaPath.equals(((JsonNode)candidateExplicitMapping.getValue()).asText())) continue;
            currentDiscriminatorContext.markMatch();
            break;
        }
    }

    private static boolean noExplicitDiscriminatorKeyOverride(JsonNode discriminatorMapping, JsonSchema parentSchema) {
        Iterator explicitMappings = discriminatorMapping.fields();
        while (explicitMappings.hasNext()) {
            Map.Entry candidateExplicitMapping = (Map.Entry)explicitMappings.next();
            if (!((JsonNode)candidateExplicitMapping.getValue()).asText().equals(parentSchema.schemaPath)) continue;
            return false;
        }
        return true;
    }
}

