/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchema schema;

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF);
        String refValue = schemaNode.asText();
        if (refValue.startsWith("#")) {
            if (refValue.equals("#")) {
                this.schema = parentSchema.findAncestor();
            } else {
                JsonNode node = parentSchema.getRefSchemaNode(refValue);
                if (node != null) {
                    this.schema = new JsonSchema(mapper, refValue, node, parentSchema);
                }
            }
        } else {
            int index = refValue.indexOf("#");
            String schemaUrl = refValue;
            if (index > 0) {
                schemaUrl = schemaUrl.substring(0, index);
            }
            JsonSchemaFactory factory = new JsonSchemaFactory(mapper);
            try {
                URL url = new URL(schemaUrl);
                parentSchema = factory.getSchema(url);
            }
            catch (MalformedURLException e) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaUrl);
                parentSchema = factory.getSchema(is);
            }
            if (index < 0) {
                this.schema = parentSchema.findAncestor();
            } else if ((refValue = refValue.substring(index)).equals("#")) {
                this.schema = parentSchema.findAncestor();
            } else {
                JsonNode node = parentSchema.getRefSchemaNode(refValue);
                if (node != null) {
                    this.schema = new JsonSchema(mapper, refValue, node, parentSchema);
                }
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schema != null) {
            return this.schema.validate(node, rootNode, at);
        }
        return new HashSet<ValidationMessage>();
    }
}

