/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(EnumValidator.class);
    private List<JsonNode> nodes = new ArrayList<JsonNode>();
    private String error = "[none]";

    public EnumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ENUM, validationContext);
        if (schemaNode != null && schemaNode.isArray()) {
            this.error = "[";
            int i = 0;
            for (JsonNode n : schemaNode) {
                this.nodes.add(n);
                String v = n.asText();
                this.error = this.error + (i == 0 ? "" : ", ") + v;
                ++i;
            }
            this.error = this.error + "]";
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!this.nodes.contains(node)) {
            errors.add(this.buildValidationMessage(at, this.error));
        }
        return Collections.unmodifiableSet(errors);
    }
}

