/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    public static final String PROPERTY = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesValidator.class);
    private Map<String, JsonSchema> schemas = new HashMap<String, JsonSchema>();

    public PropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTIES);
        Iterator it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            this.schemas.put(pname, new JsonSchema(mapper, schemaPath + "/" + pname, schemaNode.get(pname), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        for (String key : this.schemas.keySet()) {
            JsonSchema propertySchema = this.schemas.get(key);
            JsonNode propertyNode = node.get(key);
            if (propertyNode == null) continue;
            errors.addAll(propertySchema.validate(propertyNode, rootNode, at + "." + key));
        }
        return errors;
    }
}

