/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.AtomicDouble;
import java.util.Collections;

class DefaultMaxGauge
implements Gauge {
    private final Clock clock;
    private final Id id;
    private final AtomicDouble value;

    DefaultMaxGauge(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.value = new AtomicDouble(Double.NaN);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.id, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void set(double v) {
        this.value.max(v);
    }

    @Override
    public double value() {
        return this.value.get();
    }
}

